package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class TakeImagesCommand extends CameraCommand {
  private final int numImages;

  private final double expTime;

  private final boolean shutter;

  private final boolean science;

  private final boolean guide;

  private final boolean wfs;

  private final String imageType;

  private final String groupId;

  public TakeImagesCommand(int numImages, double expTime, boolean shutter, boolean science,
      boolean guide, boolean wfs, String imageType, String groupId) {
    this.numImages = numImages;
    this.expTime = expTime;
    this.shutter = shutter;
    this.science = science;
    this.guide = guide;
    this.wfs = wfs;
    this.imageType = imageType;
    this.groupId = groupId;
  }

  public int getNumImages() {
    return numImages;
  }

  public double getExpTime() {
    return expTime;
  }

  public boolean isShutter() {
    return shutter;
  }

  public boolean isScience() {
    return science;
  }

  public boolean isGuide() {
    return guide;
  }

  public boolean isWfs() {
    return wfs;
  }

  public String getImageType() {
    return imageType;
  }

  public String getGroupId() {
    return groupId;
  }

  @Override
  public String toString() {
    return "TakeImagesCommand{" + "numImages=" + numImages +", expTime=" + expTime +
        ", shutter=" + shutter +", science=" + science +", guide=" + guide +", wfs=" + wfs +
        ", imageType=" + imageType +", groupId=" + groupId +"}";
  }
}
