package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class ColdTelemetry extends CameraTelemetry {
  private final float[] compressorLoad;

  private final float[] compressorSpeed;

  private final float[] dischargePressure;

  private final float[] dischargeTemp;

  private final short[] flowInterlock;

  private final float[] heaterCurrent;

  private final float[] heaterVoltage;

  private final float[] intakeFlow;

  private final float[] intakePressure;

  private final float[] intakeTemp;

  private final float[] ionPump;

  private final short[] mechPump;

  private final float[] postExpansionPressure;

  private final float[] postExpansionTemp;

  private final float[] preExpansionPressure;

  private final float[] preExpansionTemp;

  private final int[] rga;

  private final float[] returnTemp;

  private final float utilityRoomTemperature;

  private final float[] vacuumGauge;

  private final short[] valveStatus;

  public ColdTelemetry(float[] compressorLoad, float[] compressorSpeed, float[] dischargePressure,
      float[] dischargeTemp, short[] flowInterlock, float[] heaterCurrent, float[] heaterVoltage,
      float[] intakeFlow, float[] intakePressure, float[] intakeTemp, float[] ionPump,
      short[] mechPump, float[] postExpansionPressure, float[] postExpansionTemp,
      float[] preExpansionPressure, float[] preExpansionTemp, int[] rga, float[] returnTemp,
      float utilityRoomTemperature, float[] vacuumGauge, short[] valveStatus) {
    this.compressorLoad = compressorLoad;
    this.compressorSpeed = compressorSpeed;
    this.dischargePressure = dischargePressure;
    this.dischargeTemp = dischargeTemp;
    this.flowInterlock = flowInterlock;
    this.heaterCurrent = heaterCurrent;
    this.heaterVoltage = heaterVoltage;
    this.intakeFlow = intakeFlow;
    this.intakePressure = intakePressure;
    this.intakeTemp = intakeTemp;
    this.ionPump = ionPump;
    this.mechPump = mechPump;
    this.postExpansionPressure = postExpansionPressure;
    this.postExpansionTemp = postExpansionTemp;
    this.preExpansionPressure = preExpansionPressure;
    this.preExpansionTemp = preExpansionTemp;
    this.rga = rga;
    this.returnTemp = returnTemp;
    this.utilityRoomTemperature = utilityRoomTemperature;
    this.vacuumGauge = vacuumGauge;
    this.valveStatus = valveStatus;
  }

  public float[] getCompressorLoad() {
    return compressorLoad;
  }

  public float[] getCompressorSpeed() {
    return compressorSpeed;
  }

  public float[] getDischargePressure() {
    return dischargePressure;
  }

  public float[] getDischargeTemp() {
    return dischargeTemp;
  }

  public short[] getFlowInterlock() {
    return flowInterlock;
  }

  public float[] getHeaterCurrent() {
    return heaterCurrent;
  }

  public float[] getHeaterVoltage() {
    return heaterVoltage;
  }

  public float[] getIntakeFlow() {
    return intakeFlow;
  }

  public float[] getIntakePressure() {
    return intakePressure;
  }

  public float[] getIntakeTemp() {
    return intakeTemp;
  }

  public float[] getIonPump() {
    return ionPump;
  }

  public short[] getMechPump() {
    return mechPump;
  }

  public float[] getPostExpansionPressure() {
    return postExpansionPressure;
  }

  public float[] getPostExpansionTemp() {
    return postExpansionTemp;
  }

  public float[] getPreExpansionPressure() {
    return preExpansionPressure;
  }

  public float[] getPreExpansionTemp() {
    return preExpansionTemp;
  }

  public int[] getRga() {
    return rga;
  }

  public float[] getReturnTemp() {
    return returnTemp;
  }

  public float getUtilityRoomTemperature() {
    return utilityRoomTemperature;
  }

  public float[] getVacuumGauge() {
    return vacuumGauge;
  }

  public short[] getValveStatus() {
    return valveStatus;
  }

  @Override
  public String toString() {
    return "ColdTelemetry{" + "compressorLoad=" + compressorLoad +
        ", compressorSpeed=" + compressorSpeed +", dischargePressure=" + dischargePressure +
        ", dischargeTemp=" + dischargeTemp +", flowInterlock=" + flowInterlock +
        ", heaterCurrent=" + heaterCurrent +", heaterVoltage=" + heaterVoltage +
        ", intakeFlow=" + intakeFlow +", intakePressure=" + intakePressure +
        ", intakeTemp=" + intakeTemp +", ionPump=" + ionPump +", mechPump=" + mechPump +
        ", postExpansionPressure=" + postExpansionPressure +
        ", postExpansionTemp=" + postExpansionTemp +
        ", preExpansionPressure=" + preExpansionPressure +", preExpansionTemp=" + preExpansionTemp +
        ", rga=" + rga +", returnTemp=" + returnTemp +
        ", utilityRoomTemperature=" + utilityRoomTemperature +", vacuumGauge=" + vacuumGauge +
        ", valveStatus=" + valveStatus +"}";
  }
}
