package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class LogMessageEvent extends CameraEvent {
  private final int level;

  private final String message;

  private final String traceback;

  public LogMessageEvent(int priority, int level, String message, String traceback) {
    super (priority);
    this.level = level;
    this.message = message;
    this.traceback = traceback;
  }

  public int getLevel() {
    return level;
  }

  public String getMessage() {
    return message;
  }

  public String getTraceback() {
    return traceback;
  }

  @Override
  public String toString() {
    return "LogMessageEvent{" + "level=" + level +", message=" + message +
        ", traceback=" + traceback +"}";
  }
}
