/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.CCSTelemetry;
import org.lsst.sal.camera.telemetry.ClusterEncoderTelemetry;
import org.lsst.sal.camera.telemetry.ColdTelemetry;
import org.lsst.sal.camera.telemetry.CyroTelemetry;
import org.lsst.sal.camera.telemetry.FilterTelemetry;
import org.lsst.sal.camera.telemetry.GasTelemetry;
import org.lsst.sal.camera.telemetry.GdsTelemetry;
import org.lsst.sal.camera.telemetry.HeartbeatTelemetry;
import org.lsst.sal.camera.telemetry.PcmsTelemetry;
import org.lsst.sal.camera.telemetry.ProtTelemetry;
import org.lsst.sal.camera.telemetry.PurgeTelemetry;
import org.lsst.sal.camera.telemetry.SasTelemetry;
import org.lsst.sal.camera.telemetry.SdsTelemetry;
import org.lsst.sal.camera.telemetry.ShutterTelemetry;
import org.lsst.sal.camera.telemetry.WasTelemetry;
import org.lsst.sal.camera.telemetry.WdsTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveShutterTelemetry() throws Exception {
        short[] bladeHome = new short[]{94, 220};
        float[] closeProfile = new float[]{0.4993806f, 0.9001702f, 0.8297342f, 0.76754624f, 0.44521487f, 0.510695f, 0.8736819f, 0.53389007f, 0.963172f, 0.27522123f, 0.4494468f, 0.100364864f, 0.13265306f, 0.7781202f, 0.29030818f, 0.023699284f, 0.26036018f, 0.8256701f, 0.52997047f, 0.08247328f, 0.9314156f, 0.61794317f, 0.74474066f, 0.7064469f};
        float[] motorCurrent = new float[]{0.51925343f, 0.6178314f};
        float[] motorTemp = new float[]{0.09379089f, 0.3732726f};
        short openDirection = 42;
        float[] openProfile = new float[]{0.34344143f, 0.37719345f, 0.37783432f, 0.22163934f, 0.55179244f, 0.651653f, 0.5180367f, 0.97135127f, 0.608476f, 0.22524887f, 0.96301264f, 0.06866783f, 0.34441042f, 0.22022235f, 0.32170266f, 0.83380437f, 0.7473956f, 0.22523284f, 0.04850787f, 0.5823819f, 0.2988243f, 0.83699703f, 0.2857654f, 0.23230499f};
        String profileFunction = "shqwnviuomvcitfmduyusijaprpcoegzmvmyaocdadgpicpclfqpgwoiytcrbrkmqxqawkkng";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ShutterTelemetry(bladeHome, closeProfile, motorCurrent, motorTemp, openDirection, openProfile, profileFunction));
        Assert.assertTrue((boolean)(item instanceof ShutterTelemetry));
        ShutterTelemetry item_ = (ShutterTelemetry)item;
        Assert.assertArrayEquals((short[])bladeHome, (short[])item_.getBladeHome());
        Assert.assertArrayEquals((float[])closeProfile, (float[])item_.getCloseProfile(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorCurrent, (float[])item_.getMotorCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorTemp, (float[])item_.getMotorTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)openDirection, (long)item_.getOpenDirection());
        Assert.assertArrayEquals((float[])openProfile, (float[])item_.getOpenProfile(), (float)1.0E-6f);
        Assert.assertEquals((Object)profileFunction, (Object)item_.getProfileFunction());
    }

    @Test
    public void sendReceiveProtTelemetry() throws Exception {
        int[] status = new int[]{409, 726};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ProtTelemetry(status));
        Assert.assertTrue((boolean)(item instanceof ProtTelemetry));
        ProtTelemetry item_ = (ProtTelemetry)item;
        Assert.assertArrayEquals((int[])status, (int[])item_.getStatus());
    }

    @Test
    public void sendReceiveFilterTelemetry() throws Exception {
        int loaderTelemetry = 767;
        short rebID = 451;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterTelemetry(loaderTelemetry, rebID));
        Assert.assertTrue((boolean)(item instanceof FilterTelemetry));
        FilterTelemetry item_ = (FilterTelemetry)item;
        Assert.assertEquals((long)loaderTelemetry, (long)item_.getLoaderTelemetry());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws Exception {
        boolean heartbeat = true;
        int priority = 612;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new HeartbeatTelemetry(heartbeat, priority));
        Assert.assertTrue((boolean)(item instanceof HeartbeatTelemetry));
        HeartbeatTelemetry item_ = (HeartbeatTelemetry)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveWasTelemetry() throws Exception {
        short boardID = 399;
        float[] boardCurrent = new float[]{0.6542793f, 0.37268287f, 0.46251094f, 0.3193243f};
        float[] boardTemp = new float[]{0.3706587f, 0.88690907f, 0.99370396f, 0.1980843f, 0.15577364f, 0.65969664f, 0.044072628f, 0.35289842f, 0.26424748f, 0.71716636f, 0.31904346f, 0.6289816f};
        float[] boardVoltage = new float[]{0.34782183f, 0.4623984f, 0.033944964f, 0.52440447f};
        int[] cabacMUX = new int[]{776, 127, 950, 598};
        short ccdID = 335;
        int ccdtemp = 87;
        int[] fpgaCheckSum = new int[]{602, 928};
        short rebID = 320;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof WasTelemetry));
        WasTelemetry item_ = (WasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveCCSTelemetry() throws Exception {
        int[] ccsStatus = new int[]{705, 78, 763, 291, 876, 923, 528, 205, 539, 164, 446, 339, 153, 818, 659, 628, 232, 660, 345, 747};
        int[] imageStatus = new int[]{594, 722, 459, 910, 158, 558, 566, 862, 692, 288, 549, 827, 260, 949, 84, 274, 152, 827, 710, 430};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CCSTelemetry(ccsStatus, imageStatus));
        Assert.assertTrue((boolean)(item instanceof CCSTelemetry));
        CCSTelemetry item_ = (CCSTelemetry)item;
        Assert.assertArrayEquals((int[])ccsStatus, (int[])item_.getCcsStatus());
        Assert.assertArrayEquals((int[])imageStatus, (int[])item_.getImageStatus());
    }

    @Test
    public void sendReceiveClusterEncoderTelemetry() throws Exception {
        float[] imageSD = new float[]{0.8787864f, 0.7579361f, 0.1715014f, 0.8883354f, 0.14395869f, 0.018800735f, 0.3617394f, 0.79723173f, 0.8253457f, 0.8163587f, 0.54579103f, 0.8366264f, 0.9802058f, 0.7885984f, 0.42483866f, 0.3071276f, 0.4132169f, 0.019812226f, 0.77617073f, 0.04545039f, 0.45299548f, 0.34995073f, 0.27151412f, 0.070926666f, 0.4394496f, 0.08574283f, 0.5146962f, 0.9062464f, 0.31702417f, 0.26001376f, 0.6229004f, 0.31414217f, 0.9994347f, 0.5962114f, 0.6705964f, 0.38250983f, 0.35566616f, 0.77572125f, 0.14799285f, 0.011726379f, 0.9923641f, 0.77787405f, 0.64818126f, 0.094240546f, 0.09243494f, 0.84650135f, 0.6962412f, 0.9155762f, 0.67249084f, 0.7404935f, 0.6423062f, 0.3885188f, 0.89213264f, 0.13518113f, 0.047433436f, 0.7023966f, 0.7760049f, 0.47076523f, 0.9501651f, 0.32409412f, 0.5757404f, 0.8858348f, 0.78265864f, 0.22693807f, 0.3246299f, 0.6487502f, 0.74353284f, 0.9011956f, 0.1350187f, 0.3059649f, 0.8811158f, 0.47207063f, 0.80958384f, 0.530962f, 0.51218224f, 0.9273414f, 0.1259489f, 0.8852877f, 0.42976326f, 0.5498489f, 0.093337476f, 0.7271666f, 0.43705064f, 0.62574416f, 0.84456265f, 0.73452806f, 0.39627677f, 0.02667129f, 0.031641543f, 0.6872088f, 0.28083235f, 0.46498173f, 0.4443695f, 0.5950102f, 0.7605145f, 0.92083025f, 0.5145847f, 0.109687746f, 0.9940269f, 0.7169211f};
        float[] imageMean = new float[]{0.74150616f, 0.6434655f, 0.4256611f, 0.9521959f, 0.35298115f, 0.28606188f, 0.12607193f, 0.9344544f, 0.571897f, 0.5963595f, 0.23745048f, 0.011470318f, 0.1951778f, 0.60177225f, 0.3040431f, 0.88142663f, 0.21412659f, 0.90417415f, 0.12834424f, 0.3603968f, 0.4494092f, 0.030228376f, 0.49550438f, 0.44420385f, 0.57239276f, 0.018464565f, 0.8732677f, 0.7745011f, 0.008116722f, 0.4760129f, 0.50744283f, 0.70765203f, 0.52581847f, 0.8131406f, 0.19448334f, 0.69638854f, 0.42318958f, 0.250414f, 0.18982506f, 0.68786675f, 0.09356868f, 0.24630785f, 0.98540753f, 0.48031747f, 0.06487125f, 0.7954068f, 0.110162914f, 0.17981386f, 0.8396306f, 0.26013613f, 0.23665273f, 0.97771126f, 0.71211773f, 0.0114604235f, 0.04457748f, 0.8001117f, 0.24677908f, 0.7336034f, 0.84230477f, 0.038469672f, 0.9684794f, 0.19005513f, 0.4912036f, 0.5835068f, 0.62616515f, 0.026599586f, 0.84042007f, 0.9843845f, 0.87512016f, 0.6035534f, 0.5533763f, 0.42616296f, 0.49712783f, 0.2837546f, 0.79895556f, 0.7486593f, 0.101374924f, 0.2630747f, 0.962894f, 0.25970656f, 0.27124423f, 0.20248932f, 0.9968197f, 0.16947949f, 0.13328624f, 0.2192828f, 0.71775436f, 0.08703965f, 0.5052968f, 0.41217083f, 0.76945996f, 0.8757722f, 0.95184994f, 0.05150199f, 0.7941093f, 0.9142529f, 0.94975144f, 0.95988536f, 0.8893788f, 0.309744f};
        float[] overscanSD = new float[]{0.7952384f, 0.86733603f, 0.6587892f, 0.17254132f, 0.11250186f, 0.6532259f, 0.13419604f, 0.6934769f, 0.73305935f, 0.21797144f, 0.85659575f, 0.43984562f, 0.08205372f, 0.17162406f, 0.25835347f, 0.16580886f, 0.9457472f, 0.823606f, 0.7756659f, 0.14401186f, 0.9099818f, 0.9251386f, 0.4292819f, 0.8909226f, 0.7984728f, 0.8989484f, 0.8045603f, 0.45758396f, 0.93941003f, 0.6132452f, 0.81483036f, 0.6715085f, 0.026496828f, 0.17049521f, 0.48633176f, 0.7789118f, 0.08442831f, 0.31605667f, 0.41598076f, 0.48706537f, 0.6076806f, 0.3852988f, 0.9476799f, 0.035080075f, 0.21477282f, 0.7365331f, 0.42734998f, 0.42184657f, 0.187908f, 0.22519594f, 0.8354001f, 0.5392314f, 0.4807614f, 0.90462613f, 0.3777069f, 0.6471555f, 0.24646002f, 0.060976744f, 0.2276879f, 0.28817934f, 0.6253896f, 0.25293404f, 0.05370879f, 0.47913796f, 0.5409242f, 0.9077301f, 0.5044582f, 0.39577538f, 0.073657274f, 0.47832626f, 0.74228776f, 0.045916975f, 0.75500816f, 0.27561045f, 0.9586937f, 0.8233169f, 0.8636089f, 0.015129745f, 0.64059526f, 0.7668579f, 0.6876677f, 0.34952736f, 0.00993675f, 0.6903498f, 0.28923535f, 0.26285213f, 0.37713814f, 0.6719495f, 0.7682473f, 0.076768816f, 0.24139053f, 0.22754365f, 0.4622993f, 0.93504894f, 0.46371704f, 0.5707303f, 0.15987098f, 0.29332495f, 0.123696625f, 0.8678842f};
        float[] overscanMean = new float[]{0.86830974f, 0.025825739f, 0.15500414f, 0.21788555f, 0.22210962f, 0.9776892f, 0.21130973f, 0.06325132f, 0.3912856f, 0.9265983f, 0.6310747f, 0.9165858f, 0.6439909f, 0.08516902f, 0.8014886f, 0.16051793f, 0.21261233f, 0.16811699f, 0.63793135f, 0.45083237f, 0.12970668f, 0.18624818f, 0.53127617f, 0.07462853f, 0.45120972f, 0.11139405f, 0.72203916f, 0.8445212f, 0.12191075f, 0.30929965f, 0.1544435f, 0.5556836f, 0.40539283f, 0.6660559f, 0.97711474f, 0.2076317f, 0.68129104f, 0.97095567f, 0.7882214f, 0.5628792f, 0.7812221f, 0.7757748f, 0.7848882f, 0.84889174f, 0.30613726f, 0.3667f, 0.2487483f, 0.63021845f, 0.34780306f, 0.97781694f, 0.37628645f, 0.909467f, 0.17191517f, 0.0897547f, 0.7045116f, 0.13723469f, 0.04690981f, 0.8173778f, 0.16545892f, 0.003666103f, 0.9983982f, 0.5480917f, 0.768664f, 0.08253455f, 0.70247066f, 0.27725708f, 0.71629685f, 0.74035007f, 0.5106943f, 0.4574076f, 0.3239451f, 0.29878998f, 0.124867976f, 0.6695594f, 0.88957185f, 0.542678f, 0.25054747f, 0.40215707f, 0.8280426f, 0.044879317f, 0.58566946f, 0.628489f, 0.18854606f, 0.88401896f, 0.31558007f, 0.47724944f, 0.58257735f, 0.56419635f, 0.35032028f, 0.94194067f, 0.571884f, 0.91430247f, 0.45668316f, 0.44976944f, 0.46549863f, 0.50771797f, 0.19949186f, 0.9644698f, 0.034921706f, 0.46377695f};
        float[] psf = new float[]{0.8475499f, 0.71309114f, 0.9245282f, 0.086241126f, 0.64419496f, 0.26536012f, 0.07382548f, 0.5800908f, 0.75538564f, 0.54501355f, 0.60839164f, 0.43826848f, 0.8454303f, 0.9828876f, 0.7418994f, 0.079805255f, 0.28811997f, 0.82705164f, 0.8729289f, 0.9783458f, 0.08606315f, 0.079514325f, 0.38327742f, 0.076893926f, 0.37098116f, 0.4337762f, 0.5407762f, 0.42522043f, 0.0107732415f, 0.3226267f, 0.28646177f, 0.088479936f, 0.11408645f, 0.95910287f, 0.7161639f, 0.80001396f, 0.7493444f, 0.35156757f, 0.4386468f, 0.11200529f, 0.77273774f, 0.31068933f, 0.1604752f, 0.93166995f, 0.46922284f, 0.63409215f, 0.28149313f, 0.01822418f, 0.5734026f, 0.97410613f, 0.7195647f, 0.9102601f, 0.8651876f, 0.46401232f, 0.8699944f, 0.7108558f, 0.7808997f, 0.42520612f, 0.5604331f, 0.48830038f, 0.58713967f, 0.4066761f, 0.11830467f, 0.76642823f, 0.51609665f, 0.25212336f, 0.52271163f, 0.6460507f, 0.6314314f, 0.76006114f, 0.87987196f, 0.6867908f, 0.9984662f, 0.037592053f, 0.7195051f, 0.4088412f, 0.27682108f, 0.6666459f, 0.4539482f, 0.47196645f, 0.084138334f, 0.9477828f, 0.63249964f, 0.5327886f, 0.23305213f, 0.48485178f, 0.7365258f, 0.9524612f, 0.1976214f, 0.2756111f, 0.3378386f, 0.8598362f, 0.28822005f, 0.9087363f, 0.640973f, 0.20784467f, 0.014158666f, 0.8944817f, 0.17212439f, 0.9838724f, 0.8905048f, 0.110746324f, 0.60212153f, 0.44235873f, 0.5397211f, 0.6926897f, 0.102003455f, 0.3667515f, 0.78050965f, 0.8747262f, 0.9472829f, 0.88850766f, 0.5569304f, 0.5792065f, 0.29614544f, 0.19636154f, 0.0023627877f, 0.28500617f, 0.66864777f, 0.6660289f, 0.75774306f, 0.5783386f, 0.9150266f, 0.08845544f, 0.36490005f, 0.042281568f, 0.66375035f, 0.036338627f, 0.26751482f, 0.8637517f, 0.93178177f, 0.19977874f, 0.6986639f, 0.8881233f, 0.8241538f, 0.1614902f, 0.6801071f, 0.32161433f, 0.876488f, 0.44210166f, 0.060114622f, 0.93734586f, 0.44724208f, 0.30188203f, 0.1699813f, 0.37811917f, 0.756597f, 0.26508057f, 0.37136763f, 0.94108975f, 0.3219779f, 0.36839265f, 0.72477084f, 0.3784014f, 0.04783368f, 0.9104452f, 0.85193044f, 0.63335896f, 0.49671435f, 0.88232034f, 0.050605834f, 0.7618788f, 0.5727296f, 0.13082838f, 0.998331f, 0.34988666f, 0.17562342f, 0.6904462f, 0.2425074f, 0.64329696f, 0.28806257f, 0.11362529f, 0.7981903f, 0.050585866f, 0.410033f, 0.23273724f, 0.88345504f, 0.17927194f, 0.48782492f, 0.7535896f, 0.32720798f, 0.72547305f, 0.25193703f, 0.76665074f, 0.8382721f, 0.27687806f, 0.694943f, 0.47744364f, 0.87069213f, 0.91883683f, 0.8191748f, 0.7146966f, 0.6422613f, 0.7838386f, 0.56282544f, 0.53960127f, 0.2356804f, 0.7675569f, 0.2852471f, 0.22085816f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ClusterEncoderTelemetry(imageSD, imageMean, overscanSD, overscanMean, psf));
        Assert.assertTrue((boolean)(item instanceof ClusterEncoderTelemetry));
        ClusterEncoderTelemetry item_ = (ClusterEncoderTelemetry)item;
        Assert.assertArrayEquals((float[])imageSD, (float[])item_.getImageSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])imageMean, (float[])item_.getImageMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanSD, (float[])item_.getOverscanSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanMean, (float[])item_.getOverscanMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])psf, (float[])item_.getPsf(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveCyroTelemetry() throws Exception {
        float[] coldTemperature = new float[]{0.04956305f, 0.2891341f, 0.43691498f};
        float compressor = 0.08017099f;
        float[] compressorSpeed = new float[]{0.975362f, 0.5168593f};
        float[] cryoTemperature = new float[]{0.1514669f, 0.076670706f, 0.002496183f, 0.058349967f, 0.8367744f, 0.26472765f, 0.834425f, 0.9504293f, 0.28511775f, 0.40919822f, 0.010683179f, 0.4298448f};
        float[] dischargePressure = new float[]{0.010835111f, 0.5099129f};
        float[] dischargeTemp = new float[]{0.84211725f, 0.5516842f};
        short[] flowInterlock = new short[]{988, 602};
        float[] heaterCurrent = new float[]{0.687547f, 0.20582688f, 0.8887909f, 0.13974166f, 0.12922364f, 0.49914235f};
        float[] heaterVoltage = new float[]{0.060374677f, 0.9349001f, 0.9818091f, 0.18668503f, 0.21072006f, 0.81456566f};
        float[] intakeFlow = new float[]{0.7258255f, 0.7912064f};
        float[] intakePressure = new float[]{0.7525074f, 0.480847f};
        float[] intakeTemp = new float[]{0.46290475f, 0.017427087f};
        float[] postExpansionPressure = new float[]{0.34737056f, 0.7279629f};
        float[] postExpansionTemp = new float[]{0.30862325f, 0.8943129f};
        float[] preExpansionPressure = new float[]{0.8320593f, 0.9500392f};
        float[] preExpansionTemp = new float[]{0.8717734f, 0.94183856f};
        float[] returnTemp = new float[]{0.3426444f, 0.8763936f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CyroTelemetry(coldTemperature, compressor, compressorSpeed, cryoTemperature, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, returnTemp));
        Assert.assertTrue((boolean)(item instanceof CyroTelemetry));
        CyroTelemetry item_ = (CyroTelemetry)item;
        Assert.assertArrayEquals((float[])coldTemperature, (float[])item_.getColdTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)compressor, (float)item_.getCompressor(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])cryoTemperature, (float[])item_.getCryoTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
    }

    @Test
    public void sendReceivePurgeTelemetry() throws Exception {
        float[] accelerometer = new float[]{0.10976654f, 0.31328171f, 0.17146307f, 0.5648836f, 0.03226763f, 0.89298004f};
        float blowerSetting = 0.0071698427f;
        float blowerSpeed = 0.67228264f;
        float bodyFlowMeter = 0.9735508f;
        float bodyTemp = 0.39383298f;
        float heaterCurrent = 0.15796733f;
        float heaters = 0.5137422f;
        int microphone = 871;
        float trunkFlowMeter = 0.5879006f;
        float trunkTemp = 0.4709499f;
        int valveSetting = 134;
        int valves = 992;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PurgeTelemetry(accelerometer, blowerSetting, blowerSpeed, bodyFlowMeter, bodyTemp, heaterCurrent, heaters, microphone, trunkFlowMeter, trunkTemp, valveSetting, valves));
        Assert.assertTrue((boolean)(item instanceof PurgeTelemetry));
        PurgeTelemetry item_ = (PurgeTelemetry)item;
        Assert.assertArrayEquals((float[])accelerometer, (float[])item_.getAccelerometer(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSetting, (float)item_.getBlowerSetting(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSpeed, (float)item_.getBlowerSpeed(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyFlowMeter, (float)item_.getBodyFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyTemp, (float)item_.getBodyTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)heaterCurrent, (float)item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)heaters, (float)item_.getHeaters(), (float)1.0E-6f);
        Assert.assertEquals((long)microphone, (long)item_.getMicrophone());
        Assert.assertEquals((float)trunkFlowMeter, (float)item_.getTrunkFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)trunkTemp, (float)item_.getTrunkTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)valveSetting, (long)item_.getValveSetting());
        Assert.assertEquals((long)valves, (long)item_.getValves());
    }

    @Test
    public void sendReceiveWdsTelemetry() throws Exception {
        short rebID = 929;
        int[] timingParameters = new int[]{306, 696, 519, 496, 84, 51, 895, 258, 454, 376};
        int[] flag = new int[]{592, 5, 102, 378, 447, 125, 896, 180, 598, 323, 693, 639, 599, 212, 654, 16, 457, 532, 854, 499};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof WdsTelemetry));
        WdsTelemetry item_ = (WdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGdsTelemetry() throws Exception {
        short rebID = 125;
        int[] timingParameters = new int[]{16, 413, 958, 187, 750, 193, 227, 309, 57, 270};
        int[] flag = new int[]{363, 637, 20, 638, 804, 138, 810, 588, 967, 854, 936, 202, 728, 731, 976, 91, 59, 683, 51, 259};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof GdsTelemetry));
        GdsTelemetry item_ = (GdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveSdsTelemetry() throws Exception {
        short rebID = 967;
        int[] timingParameters = new int[]{647, 802, 490, 354, 631, 280, 407, 625, 625, 295};
        int[] flag = new int[]{617, 402, 468, 534, 209, 176, 756, 44, 755, 794, 152, 525, 612, 513, 318, 510, 509, 203, 489, 573};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof SdsTelemetry));
        SdsTelemetry item_ = (SdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGasTelemetry() throws Exception {
        short boardID = 693;
        float[] boardCurrent = new float[]{0.7584035f, 0.8805615f, 0.39524424f, 0.44115192f};
        float[] boardTemp = new float[]{0.55432135f, 0.20808667f, 0.14494377f, 0.75142473f, 0.7411676f, 0.45281196f, 0.9956295f, 0.3998481f, 0.1898796f, 0.5980871f, 0.041514397f, 0.6667261f};
        float[] boardVoltage = new float[]{0.43983322f, 0.65128314f, 0.049217522f, 0.12424785f};
        int[] cabacMUX = new int[]{618, 993, 724, 221};
        short ccdID = 132;
        int ccdtemp = 645;
        int[] fpgaCheckSum = new int[]{17, 135};
        short rebID = 246;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof GasTelemetry));
        GasTelemetry item_ = (GasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceivePcmsTelemetry() throws Exception {
        short biasStatus = 671;
        float biasCurrent = 0.34356874f;
        float biasVoltage = 0.4499297f;
        short clockStatus = 362;
        short clockCurrent = 343;
        float clockVoltage = 0.70411587f;
        short fpgaStatus = 417;
        float fpgaCurrent = 0.15868676f;
        float fpgaVoltage = 0.53721815f;
        short lowStatus = 5;
        float lowCurrent = 0.5459669f;
        short lowVoltage = 966;
        short odStatus = 159;
        float odCurrent = 0.69069153f;
        float odVoltage = 0.6232205f;
        float rebID = 0.5039003f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PcmsTelemetry(biasStatus, biasCurrent, biasVoltage, clockStatus, clockCurrent, clockVoltage, fpgaStatus, fpgaCurrent, fpgaVoltage, lowStatus, lowCurrent, lowVoltage, odStatus, odCurrent, odVoltage, rebID));
        Assert.assertTrue((boolean)(item instanceof PcmsTelemetry));
        PcmsTelemetry item_ = (PcmsTelemetry)item;
        Assert.assertEquals((long)biasStatus, (long)item_.getBiasStatus());
        Assert.assertEquals((float)biasCurrent, (float)item_.getBiasCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)biasVoltage, (float)item_.getBiasVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)clockStatus, (long)item_.getClockStatus());
        Assert.assertEquals((long)clockCurrent, (long)item_.getClockCurrent());
        Assert.assertEquals((float)clockVoltage, (float)item_.getClockVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)fpgaStatus, (long)item_.getFpgaStatus());
        Assert.assertEquals((float)fpgaCurrent, (float)item_.getFpgaCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)fpgaVoltage, (float)item_.getFpgaVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)lowStatus, (long)item_.getLowStatus());
        Assert.assertEquals((float)lowCurrent, (float)item_.getLowCurrent(), (float)1.0E-6f);
        Assert.assertEquals((long)lowVoltage, (long)item_.getLowVoltage());
        Assert.assertEquals((long)odStatus, (long)item_.getOdStatus());
        Assert.assertEquals((float)odCurrent, (float)item_.getOdCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)odVoltage, (float)item_.getOdVoltage(), (float)1.0E-6f);
        Assert.assertEquals((float)rebID, (float)item_.getRebID(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveSasTelemetry() throws Exception {
        short boardID = 832;
        float[] boardCurrent = new float[]{0.3661847f, 0.3001787f, 0.88344246f, 0.14057273f};
        float[] boardTemp = new float[]{0.61737084f, 0.9612027f, 0.048015118f, 0.30751663f, 0.88625693f, 0.2429012f, 0.45531416f, 0.7473426f, 0.13618344f, 0.48783565f, 0.5048176f, 0.57634664f};
        float[] boardVoltage = new float[]{0.58302766f, 0.18113607f, 0.12990832f, 0.71057284f};
        int[] cabacMUX = new int[]{550, 850, 128, 105};
        short ccdID = 231;
        int ccdtemp = 208;
        int[] fpgaCheckSum = new int[]{140, 306};
        short rebID = 856;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof SasTelemetry));
        SasTelemetry item_ = (SasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveColdTelemetry() throws Exception {
        float[] compressorLoad = new float[]{0.21903265f, 0.932983f, 0.973775f, 0.3396545f, 0.3942485f, 0.06861794f};
        float[] compressorSpeed = new float[]{0.93467426f, 0.67454183f, 0.14120907f, 0.45004606f, 0.7089153f, 0.20766753f};
        float[] dischargePressure = new float[]{0.31833577f, 0.091483355f, 0.87396944f, 0.011934459f, 0.8722002f, 0.13280964f};
        float[] dischargeTemp = new float[]{0.22874731f, 0.44182825f, 0.4428752f, 0.014871478f, 0.7785091f, 0.29804146f};
        short[] flowInterlock = new short[]{566, 608, 489, 422, 887, 552};
        float[] heaterCurrent = new float[]{0.6544218f, 0.58131343f, 0.5212643f, 0.7867779f, 0.49979186f, 0.8632793f};
        float[] heaterVoltage = new float[]{0.8847594f, 0.8851887f, 0.7348409f, 0.23631883f, 0.20344234f, 0.96995753f};
        float[] intakeFlow = new float[]{0.30715775f, 0.09066445f, 0.4878164f, 0.6894886f, 0.04080832f, 0.46903098f};
        float[] intakePressure = new float[]{0.92431545f, 0.36482674f, 0.3376835f, 0.37369293f, 0.45799845f, 0.7849602f};
        float[] intakeTemp = new float[]{0.5333129f, 0.97985f, 0.8697411f, 0.73152435f, 0.18049961f, 0.92349297f};
        float[] ionPump = new float[]{0.34092408f, 0.013272345f, 0.106493056f, 0.83456105f};
        short[] mechPump = new short[]{722, 588, 248, 524};
        float[] postExpansionPressure = new float[]{0.015667975f, 0.33322024f, 0.91519874f, 0.5983132f, 0.3930413f, 0.12675136f};
        float[] postExpansionTemp = new float[]{0.3148263f, 0.733615f, 0.66971135f, 0.050904036f, 0.3045209f, 0.69883555f};
        float[] preExpansionPressure = new float[]{0.22198176f, 0.7720784f, 0.03413683f, 0.5856907f, 0.05425793f, 0.30657256f};
        float[] preExpansionTemp = new float[]{0.914562f, 0.8024911f, 0.5618668f, 0.65246296f, 0.8501238f, 0.73717576f};
        int[] rga = new int[]{882, 463, 796, 406, 305, 55, 942, 791, 818, 886};
        float[] returnTemp = new float[]{0.33723027f, 0.9117512f, 0.26001537f, 0.15313941f, 0.9253021f, 0.87222236f};
        float utilityRoomTemperature = 0.11161643f;
        float[] vacuumGauge = new float[]{0.4767692f, 0.61355203f, 0.46754116f, 0.4446919f, 0.3485068f};
        short[] valveStatus = new short[]{243, 691, 562, 37, 75, 518};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ColdTelemetry(compressorLoad, compressorSpeed, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, ionPump, mechPump, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, rga, returnTemp, utilityRoomTemperature, vacuumGauge, valveStatus));
        Assert.assertTrue((boolean)(item instanceof ColdTelemetry));
        ColdTelemetry item_ = (ColdTelemetry)item;
        Assert.assertArrayEquals((float[])compressorLoad, (float[])item_.getCompressorLoad(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])ionPump, (float[])item_.getIonPump(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])mechPump, (short[])item_.getMechPump());
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])rga, (int[])item_.getRga());
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)utilityRoomTemperature, (float)item_.getUtilityRoomTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])vacuumGauge, (float[])item_.getVacuumGauge(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])valveStatus, (short[])item_.getValveStatus());
    }
}

