package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class PurgeTelemetry extends CameraTelemetry {
  private final float[] accelerometer;

  private final float blowerSetting;

  private final float blowerSpeed;

  private final float bodyFlowMeter;

  private final float bodyTemp;

  private final float heaterCurrent;

  private final float heaters;

  private final int microphone;

  private final float trunkFlowMeter;

  private final float trunkTemp;

  private final int valveSetting;

  private final int valves;

  public PurgeTelemetry(float[] accelerometer, float blowerSetting, float blowerSpeed,
      float bodyFlowMeter, float bodyTemp, float heaterCurrent, float heaters, int microphone,
      float trunkFlowMeter, float trunkTemp, int valveSetting, int valves) {
    this.accelerometer = accelerometer;
    this.blowerSetting = blowerSetting;
    this.blowerSpeed = blowerSpeed;
    this.bodyFlowMeter = bodyFlowMeter;
    this.bodyTemp = bodyTemp;
    this.heaterCurrent = heaterCurrent;
    this.heaters = heaters;
    this.microphone = microphone;
    this.trunkFlowMeter = trunkFlowMeter;
    this.trunkTemp = trunkTemp;
    this.valveSetting = valveSetting;
    this.valves = valves;
  }

  public float[] getAccelerometer() {
    return accelerometer;
  }

  public float getBlowerSetting() {
    return blowerSetting;
  }

  public float getBlowerSpeed() {
    return blowerSpeed;
  }

  public float getBodyFlowMeter() {
    return bodyFlowMeter;
  }

  public float getBodyTemp() {
    return bodyTemp;
  }

  public float getHeaterCurrent() {
    return heaterCurrent;
  }

  public float getHeaters() {
    return heaters;
  }

  public int getMicrophone() {
    return microphone;
  }

  public float getTrunkFlowMeter() {
    return trunkFlowMeter;
  }

  public float getTrunkTemp() {
    return trunkTemp;
  }

  public int getValveSetting() {
    return valveSetting;
  }

  public int getValves() {
    return valves;
  }

  @Override
  public String toString() {
    return "PurgeTelemetry{" + "accelerometer=" + accelerometer +
        ", blowerSetting=" + blowerSetting +", blowerSpeed=" + blowerSpeed +
        ", bodyFlowMeter=" + bodyFlowMeter +", bodyTemp=" + bodyTemp +
        ", heaterCurrent=" + heaterCurrent +", heaters=" + heaters +", microphone=" + microphone +
        ", trunkFlowMeter=" + trunkFlowMeter +", trunkTemp=" + trunkTemp +
        ", valveSetting=" + valveSetting +", valves=" + valves +"}";
  }
}
