package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class PcmsTelemetry extends CameraTelemetry {
  private final short biasStatus;

  private final float biasCurrent;

  private final float biasVoltage;

  private final short clockStatus;

  private final short clockCurrent;

  private final float clockVoltage;

  private final short fpgaStatus;

  private final float fpgaCurrent;

  private final float fpgaVoltage;

  private final short lowStatus;

  private final float lowCurrent;

  private final short lowVoltage;

  private final short odStatus;

  private final float odCurrent;

  private final float odVoltage;

  private final float rebID;

  public PcmsTelemetry(short biasStatus, float biasCurrent, float biasVoltage, short clockStatus,
      short clockCurrent, float clockVoltage, short fpgaStatus, float fpgaCurrent,
      float fpgaVoltage, short lowStatus, float lowCurrent, short lowVoltage, short odStatus,
      float odCurrent, float odVoltage, float rebID) {
    this.biasStatus = biasStatus;
    this.biasCurrent = biasCurrent;
    this.biasVoltage = biasVoltage;
    this.clockStatus = clockStatus;
    this.clockCurrent = clockCurrent;
    this.clockVoltage = clockVoltage;
    this.fpgaStatus = fpgaStatus;
    this.fpgaCurrent = fpgaCurrent;
    this.fpgaVoltage = fpgaVoltage;
    this.lowStatus = lowStatus;
    this.lowCurrent = lowCurrent;
    this.lowVoltage = lowVoltage;
    this.odStatus = odStatus;
    this.odCurrent = odCurrent;
    this.odVoltage = odVoltage;
    this.rebID = rebID;
  }

  public short getBiasStatus() {
    return biasStatus;
  }

  public float getBiasCurrent() {
    return biasCurrent;
  }

  public float getBiasVoltage() {
    return biasVoltage;
  }

  public short getClockStatus() {
    return clockStatus;
  }

  public short getClockCurrent() {
    return clockCurrent;
  }

  public float getClockVoltage() {
    return clockVoltage;
  }

  public short getFpgaStatus() {
    return fpgaStatus;
  }

  public float getFpgaCurrent() {
    return fpgaCurrent;
  }

  public float getFpgaVoltage() {
    return fpgaVoltage;
  }

  public short getLowStatus() {
    return lowStatus;
  }

  public float getLowCurrent() {
    return lowCurrent;
  }

  public short getLowVoltage() {
    return lowVoltage;
  }

  public short getOdStatus() {
    return odStatus;
  }

  public float getOdCurrent() {
    return odCurrent;
  }

  public float getOdVoltage() {
    return odVoltage;
  }

  public float getRebID() {
    return rebID;
  }

  @Override
  public String toString() {
    return "PcmsTelemetry{" + "biasStatus=" + biasStatus +", biasCurrent=" + biasCurrent +
        ", biasVoltage=" + biasVoltage +", clockStatus=" + clockStatus +
        ", clockCurrent=" + clockCurrent +", clockVoltage=" + clockVoltage +
        ", fpgaStatus=" + fpgaStatus +", fpgaCurrent=" + fpgaCurrent +
        ", fpgaVoltage=" + fpgaVoltage +", lowStatus=" + lowStatus +", lowCurrent=" + lowCurrent +
        ", lowVoltage=" + lowVoltage +", odStatus=" + odStatus +", odCurrent=" + odCurrent +
        ", odVoltage=" + odVoltage +", rebID=" + rebID +"}";
  }
}
