package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class CyroTelemetry extends CameraTelemetry {
  private final float[] coldTemperature;

  private final float compressor;

  private final float[] compressorSpeed;

  private final float[] cryoTemperature;

  private final float[] dischargePressure;

  private final float[] dischargeTemp;

  private final short[] flowInterlock;

  private final float[] heaterCurrent;

  private final float[] heaterVoltage;

  private final float[] intakeFlow;

  private final float[] intakePressure;

  private final float[] intakeTemp;

  private final float[] postExpansionPressure;

  private final float[] postExpansionTemp;

  private final float[] preExpansionPressure;

  private final float[] preExpansionTemp;

  private final float[] returnTemp;

  public CyroTelemetry(float[] coldTemperature, float compressor, float[] compressorSpeed,
      float[] cryoTemperature, float[] dischargePressure, float[] dischargeTemp,
      short[] flowInterlock, float[] heaterCurrent, float[] heaterVoltage, float[] intakeFlow,
      float[] intakePressure, float[] intakeTemp, float[] postExpansionPressure,
      float[] postExpansionTemp, float[] preExpansionPressure, float[] preExpansionTemp,
      float[] returnTemp) {
    this.coldTemperature = coldTemperature;
    this.compressor = compressor;
    this.compressorSpeed = compressorSpeed;
    this.cryoTemperature = cryoTemperature;
    this.dischargePressure = dischargePressure;
    this.dischargeTemp = dischargeTemp;
    this.flowInterlock = flowInterlock;
    this.heaterCurrent = heaterCurrent;
    this.heaterVoltage = heaterVoltage;
    this.intakeFlow = intakeFlow;
    this.intakePressure = intakePressure;
    this.intakeTemp = intakeTemp;
    this.postExpansionPressure = postExpansionPressure;
    this.postExpansionTemp = postExpansionTemp;
    this.preExpansionPressure = preExpansionPressure;
    this.preExpansionTemp = preExpansionTemp;
    this.returnTemp = returnTemp;
  }

  public float[] getColdTemperature() {
    return coldTemperature;
  }

  public float getCompressor() {
    return compressor;
  }

  public float[] getCompressorSpeed() {
    return compressorSpeed;
  }

  public float[] getCryoTemperature() {
    return cryoTemperature;
  }

  public float[] getDischargePressure() {
    return dischargePressure;
  }

  public float[] getDischargeTemp() {
    return dischargeTemp;
  }

  public short[] getFlowInterlock() {
    return flowInterlock;
  }

  public float[] getHeaterCurrent() {
    return heaterCurrent;
  }

  public float[] getHeaterVoltage() {
    return heaterVoltage;
  }

  public float[] getIntakeFlow() {
    return intakeFlow;
  }

  public float[] getIntakePressure() {
    return intakePressure;
  }

  public float[] getIntakeTemp() {
    return intakeTemp;
  }

  public float[] getPostExpansionPressure() {
    return postExpansionPressure;
  }

  public float[] getPostExpansionTemp() {
    return postExpansionTemp;
  }

  public float[] getPreExpansionPressure() {
    return preExpansionPressure;
  }

  public float[] getPreExpansionTemp() {
    return preExpansionTemp;
  }

  public float[] getReturnTemp() {
    return returnTemp;
  }

  @Override
  public String toString() {
    return "CyroTelemetry{" + "coldTemperature=" + coldTemperature +", compressor=" + compressor +
        ", compressorSpeed=" + compressorSpeed +", cryoTemperature=" + cryoTemperature +
        ", dischargePressure=" + dischargePressure +", dischargeTemp=" + dischargeTemp +
        ", flowInterlock=" + flowInterlock +", heaterCurrent=" + heaterCurrent +
        ", heaterVoltage=" + heaterVoltage +", intakeFlow=" + intakeFlow +
        ", intakePressure=" + intakePressure +", intakeTemp=" + intakeTemp +
        ", postExpansionPressure=" + postExpansionPressure +
        ", postExpansionTemp=" + postExpansionTemp +
        ", preExpansionPressure=" + preExpansionPressure +", preExpansionTemp=" + preExpansionTemp +
        ", returnTemp=" + returnTemp +"}";
  }
}
