package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class HeartbeatTelemetry extends CameraTelemetry {
  private final boolean heartbeat;

  private final int priority;

  public HeartbeatTelemetry(boolean heartbeat, int priority) {
    this.heartbeat = heartbeat;
    this.priority = priority;
  }

  public boolean isHeartbeat() {
    return heartbeat;
  }

  public int getPriority() {
    return priority;
  }

  @Override
  public String toString() {
    return "HeartbeatTelemetry{" + "heartbeat=" + heartbeat +", priority=" + priority +"}";
  }
}
