package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class ShutterDetailedStateEvent extends CameraStateChangeEvent {
  private final ShutterState substate;

  public ShutterDetailedStateEvent(int priority, ShutterState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public ShutterState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "ShutterDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum ShutterState implements SALEnum {
    CLOSED,

    OPEN,

    CLOSING,

    OPENING
  }
}
