package org.lsst.sal.camera.telemetry;

import MTCamera.cold;
import org.lsst.sal.camera.CameraTelemetry;

/**
 *
 * @author tonyj
 */
public class CameraColdTelemetry extends CameraTelemetry {

    private final float[] Compressor_load = new float[6];
    private final float[] Compressor_speed = new float[6];
    private final float[] Discharge_pressure = new float[6];
    private final float[] Discharge_temp = new float[6];
    private final short[] Flow_interlock = new short[6];
    private final float[] Heater_current = new float[6];
    private final float[] Heater_voltage = new float[6];
    private final float[] Intake_flow = new float[6];
    private final float[] Intake_pressure = new float[6];
    private final float[] Intake_temp = new float[6];
    private final float[] Ion_pump = new float[4];
    private final short[] Mech_pump = new short[4];
    private final float[] Post_expansion_pressure = new float[6];
    private final float[] Post_expansion_temp = new float[6];
    private final float[] Pre_expansion_pressure = new float[6];
    private final float[] Pre_expansion_temp = new float[6];
    private final int[] RGA = new int[10];
    private final float[] Return_temp = new float[6];
    private float UtilityRoom_temperature;
    private final float[] Vacuum_gauge = new float[5];
    private final short[] Valve_status = new short[6];
    
    public CameraColdTelemetry() {
        
    }

    public CameraColdTelemetry(cold data) {
        System.arraycopy(Compressor_load,0,data.compressorLoad,0,Compressor_load.length);
        System.arraycopy(Compressor_speed,0,data.compressorSpeed,0,Compressor_speed.length);
        System.arraycopy(Discharge_pressure,0,data.dischargePressure,0,Discharge_pressure.length);
        System.arraycopy(Discharge_temp ,0,data.dischargeTemp,0,Discharge_temp.length);
        System.arraycopy(Flow_interlock, 0, data.flowInterlock,0,Flow_interlock.length);
        System.arraycopy(Heater_current, 0, data.heaterCurrent,0,Heater_current.length);
        System.arraycopy(Heater_voltage, 0, data.heaterVoltage,0,Heater_voltage.length);
        System.arraycopy(Intake_flow, 0, data.intakeFlow,0,Intake_flow.length);
        System.arraycopy(Intake_pressure, 0, data.intakePressure,0,Intake_pressure.length);
        System.arraycopy(Intake_temp, 0, data.intakeTemp,0,Intake_temp.length);
        System.arraycopy(Ion_pump, 0, data.ionPump,0,Ion_pump.length);
        System.arraycopy(Mech_pump, 0, data.mechPump,0,Mech_pump.length);
        System.arraycopy(Post_expansion_pressure, 0, data.postExpansionPressure,0,Post_expansion_pressure.length);
        System.arraycopy(Post_expansion_temp, 0, data.postExpansionTemp,0,Post_expansion_temp.length);
        System.arraycopy(Pre_expansion_pressure, 0, data.preExpansionPressure,0,Pre_expansion_pressure.length);
        System.arraycopy(Pre_expansion_temp, 0, data.preExpansionTemp,0,Pre_expansion_temp.length);
        System.arraycopy(RGA, 0, data.rga,0,RGA.length);
        System.arraycopy(Return_temp, 0, data.returnTemp,0,Return_temp.length);
        UtilityRoom_temperature = data.utilityRoomTemperature;
        System.arraycopy(Vacuum_gauge, 0, data.vacuumGauge,0,Vacuum_gauge.length);
        System.arraycopy(Valve_status, 0, data.valveStatus,0,Valve_status.length);
    }

    public float getUtilityRoom_temperature() {
        return UtilityRoom_temperature;
    }

    public void setUtilityRoom_temperature(float UtilityRoom_temperature) {
        this.UtilityRoom_temperature = UtilityRoom_temperature;
    }

    public float[] getCompressor_load() {
        return Compressor_load;
    }

    public float[] getCompressor_speed() {
        return Compressor_speed;
    }

    public float[] getDischaarge_pressure() {
        return Discharge_pressure;
    }

    public float[] getDischarge_temp() {
        return Discharge_temp;
    }

    public short[] getFlow_interlock() {
        return Flow_interlock;
    }

    public float[] getHeater_current() {
        return Heater_current;
    }

    public float[] getHeater_voltage() {
        return Heater_voltage;
    }

    public float[] getIntake_flow() {
        return Intake_flow;
    }

    public float[] getIntake_pressure() {
        return Intake_pressure;
    }

    public float[] getIntake_temp() {
        return Intake_temp;
    }

    public float[] getIon_pump() {
        return Ion_pump;
    }

    public short[] getMech_pump() {
        return Mech_pump;
    }

    public float[] getPost_expansion_pressure() {
        return Post_expansion_pressure;
    }

    public float[] getPost_expansion_temp() {
        return Post_expansion_temp;
    }

    public float[] getPre_expansion_pressure() {
        return Pre_expansion_pressure;
    }

    public float[] getPre_expansion_temp() {
        return Pre_expansion_temp;
    }

    public int[] getRGA() {
        return RGA;
    }

    public float[] getReturn_temp() {
        return Return_temp;
    }

    public float[] getVacuum_gauge() {
        return Vacuum_gauge;
    }

    public short[] getValve_status() {
        return Valve_status;
    }
    
}
