package org.lsst.sal.camera.states;

import org.lsst.sal.SAL_MTCamera;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 * The SummaryStateEvent (for LSE209 state changes)
 * @author tonyj
 */
public class SummaryStateEvent extends CameraStateChangeEvent {

    private final LSE209State state;

    public enum LSE209State implements SALEnum<LSE209State> {
        OFFLINE(SAL_MTCamera.SAL__STATE_OFFLINE), 
        STANDBY(SAL_MTCamera.SAL__STATE_STANDBY), 
        DISABLED(SAL_MTCamera.SAL__STATE_DISABLED), 
        ENABLED(SAL_MTCamera.SAL__STATE_ENABLED), 
        FAULT(SAL_MTCamera.SAL__STATE_FAULT);

        private final int salValue;
        
        private LSE209State(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
        
    };

    public SummaryStateEvent(int priority, LSE209State state) {
        super(priority);
        this.state = state;
    }

    @Override
    public LSE209State getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "SummaryStateEvent{" + "state=" + state + '}';
    }
}
