package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class FilterChangerDetailedStateEvent extends CameraStateChangeEvent {

    public enum FilterChangerState implements SALEnum<FilterChangerState> {

        ROTATING(MTCamera.filterChangerDetailedState_ROTATING.value), 
        UNLOADED(MTCamera.filterChangerDetailedState_UNLOADED.value),
        LOADED(MTCamera.filterChangerDetailedState_LOADED.value), 
        UNLOADING(MTCamera.filterChangerDetailedState_UNLOADING.value), 
        LOADING(MTCamera.filterChangerDetailedState_LOADING.value);
        
        private final int salValue;
        
        private FilterChangerState(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
    };

    private final FilterChangerState state;
    
    public FilterChangerDetailedStateEvent(int priority, FilterChangerState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public FilterChangerState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "FilterChangerDetailedState{" + "state=" + state + '}';
    }
}
