package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

/**
 *
 * @author tonyj
 */
public class ImageReadoutParametersEvent extends CameraEvent {
    
    public enum CCDType implements SALEnum<CCDType> { E2V, ITL };
    private final String imageName;
    private final String ccdNames;
    private final CCDType[] ccdType;
    private final int[] overRows;
    private final int[] overCols;
    private final int[] readRows;
    private final int[] readCols;
    private final int[] readCols2;
    private final int[] preCols;
    private final int[] preRows;
    private final int[] postCols;

    public ImageReadoutParametersEvent(int priority, String imageName, String ccdNames, CCDType[] ccdType, int[] overRows, int[] overCols, int[] readRows, int[] readCols, int[] readCols2, int[] preCols, int[] preRows, int[] postCols) {
        super(priority);
        this.imageName = imageName;
        this.ccdNames = ccdNames;
        this.ccdType = ccdType;
        this.overRows = overRows;
        this.overCols = overCols;
        this.readRows = readRows;
        this.readCols = readCols;
        this.readCols2 = readCols2;
        this.preCols = preCols;
        this.preRows = preRows;
        this.postCols = postCols;
    }

    public String getImageName() {
        return imageName;
    }

    public String getCcdNames() {
        return ccdNames;
    }

    public CCDType[] getCcdType() {
        return ccdType;
    }

    public int[] getOverRows() {
        return overRows;
    }

    public int[] getOverCols() {
        return overCols;
    }

    public int[] getReadRows() {
        return readRows;
    }

    public int[] getReadCols() {
        return readCols;
    }

    public int[] getReadCols2() {
        return readCols2;
    }

    public int[] getPreCols() {
        return preCols;
    }

    public int[] getPreRows() {
        return preRows;
    }

    public int[] getPostCols() {
        return postCols;
    }

    @Override
    public String toString() {
        return "ImageReadoutParameters{" + "imageName=" + imageName + ", ccdNames=" + ccdNames + ", ccdType=" + Arrays.toString(ccdType) + ", overRows=" + Arrays.toString(overRows) + 
                ", overCols=" + Arrays.toString(overCols) + ", readRows=" + Arrays.toString(readRows) + ", readCols=" + Arrays.toString(readCols) + 
                ", readCols2=" + Arrays.toString(readCols2) + ", preCols=" + Arrays.toString(preCols) + ", preRows=" + Arrays.toString(preRows) + ", postCols=" + Arrays.toString(postCols) + '}';
    }
}
