package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

/**
 *
 * @author tonyj
 */
public class TakeImagesCommand extends CameraCommand {

    private final double expTime;
    private final int numImages;
    private final boolean shutter;
    private final boolean science;
    private final boolean wfs;
    private final boolean guide;
    private final String imageSequenceName;

    public TakeImagesCommand(double expTime, int numImages, boolean shutter, boolean science, boolean wfs, boolean guide, String imageSequenceName) {
        this.expTime = expTime;
        this.numImages = numImages;
        this.shutter = shutter;
        this.science = science;
        this.wfs = wfs;
        this.guide = guide;
        this.imageSequenceName = imageSequenceName;
    }


    public double getExpTime() {
        return expTime;
    }

    public int getNumImages() {
        return numImages;
    }

    public boolean isShutter() {
        return shutter;
    }

    public boolean isScience() {
        return science;
    }

    public boolean isWfs() {
        return wfs;
    }

    public boolean isGuide() {
        return guide;
    }

    public String getImageSequenceName() {
        return imageSequenceName;
    }

    @Override
    public String toString() {
        return "TakeImagesCommand{" + "expTime=" + expTime + ", numImages=" + numImages + ", shutter=" + shutter + ", science=" + science + ", wfs=" + wfs + ", guide=" + guide + ", imageSequenceName=" + imageSequenceName + '}';
    }

}
