package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;


/**
 * *
 * @author Farrukh Azfar
 */
public class StartImageCommand extends CameraCommand {

    private final String imageSequenceName;
    private final boolean shutter;
    private final boolean science;
    private final boolean wfs;
    private final boolean guide;
    private final double timeout;

    public StartImageCommand(String imageSequenceName, boolean shutter, boolean wfs, boolean science, boolean guide, double timeout) {
        this.imageSequenceName = imageSequenceName;
        this.shutter = shutter;
        this.science = science;
        this.wfs = wfs;
        this.guide = guide;
        this.timeout = timeout;
    }

    public double getTimeout() {
        return timeout;
    }

    public boolean isShutter() {
        return shutter;
    }

    public boolean isScience() {
        return science;
    }

    public boolean isWfs() {
        return wfs;
    }

    public boolean isGuide() {
        return guide;
    }

    public String getImageSequenceName() {
        return imageSequenceName;
    }


    @Override
    public String toString() {
        return "StartImageCommand{" + "imageSequenceName=" + imageSequenceName + ", shutter=" + shutter + ", science=" + science + ", wfs=" + wfs + ", guide=" + guide + ", timeout=" + timeout + '}';
    }

}
