package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

/**
 *
 * @author tonyj
 */
public class VacuumTelemetry extends CameraTelemetry {

    private final float tempCCD;
    private final float tempColdPlate;
    private final float tempCryoHead;
    private final float vacuum;

    public VacuumTelemetry(float tempCCD, float tempColdPlate, float tempCryoHead, float vacuum) {
        this.tempCCD = tempCCD;
        this.tempColdPlate = tempColdPlate;
        this.tempCryoHead = tempCryoHead;
        this.vacuum = vacuum;
    }

    public float getTempCCD() {
        return tempCCD;
    }

    public float getTempColdPlate() {
        return tempColdPlate;
    }

    public float getTempCryoHead() {
        return tempCryoHead;
    }

    public float getVacuum() {
        return vacuum;
    }

    @Override
    public String toString() {
        return "VacuumTelemetry{" + "tempCCD=" + tempCCD + ", tempColdPlate=" + tempColdPlate + ", tempCryoHead=" + tempCryoHead + ", vacuum=" + vacuum + '}';
    }

}
