package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

/**
 *
 * @author Farrukh Azfar
 */
public class HeartbeatTelemetry extends CameraTelemetry {
    
    private final boolean heartbeat;
    private final int priority;

    public HeartbeatTelemetry(boolean heartbeat, int priority) {
        this.heartbeat = heartbeat;
        this.priority = priority;
    }

    public boolean isHeartbeat() {
        return heartbeat;
    }

    public int getPriority() {
        return priority;
    }

    @Override
    public String toString() {
        return "Heartbeat{" + "heartbeat=" + heartbeat + ", priority=" + priority + '}';
    }
    
  
}
