package org.lsst.sal.atcamera.event;
import org.lsst.sal.camera.CameraEvent;

/**
 *
 * @author Farrukh Azfar
 */
public class BonnShutterSettingsAppliedEvent extends CameraEvent {

    private final int version;
    private final float startA;
    private final float startB;
    private final float travelDistance;
    private final float startVelocity;
    private final float acceleration;
    private final float maxVelocity;
    private final float threshold;
    private final String shutterVersion;
    private final String firmwareVersion;

    public BonnShutterSettingsAppliedEvent(int priority, int version, float startA, float startB, float travelDistance, float startVelocity, float acceleration, float maxVelocity, float threshold, String shutterVersion, String firmwareVersion ) {
        super(priority);
        this.version = version;
        this.startA = startA;
        this.startB = startB;
        this.travelDistance = travelDistance;
        this.startVelocity = startVelocity;
        this.acceleration = acceleration;
        this.maxVelocity = maxVelocity;
        this.threshold = threshold;
        this.shutterVersion = shutterVersion;
        this.firmwareVersion = firmwareVersion;
    }

    public int getVersion() {
        return version;
    }

    public float getStartA() {
        return startA;
    }

    public float getStartB() {
        return startB;
    }

    public float getTravelDistance() {
        return travelDistance;
    }

    public float getStartVelocity() {
        return startVelocity;
    }

    public float getAcceleration() {
        return acceleration;
    }

    public float getMaxVelocity() {
        return maxVelocity;
    }

    public float getThreshold() {
        return threshold;
    }

    public String getShutterVersion() {
        return shutterVersion;
    }

    public String getFirmwareVersion() {
        return firmwareVersion;
    }

    @Override
    public String toString() {
        return "BonnShutterSettingsApplied{" + "version=" + version + ", startA=" + startA + ", startB=" + startB + ", travelDistance=" + travelDistance + ", startVelocity=" + startVelocity + ", acceleration=" + acceleration + ", maxVelocity=" + maxVelocity + ", threshold=" + threshold + ", shutterVersion=" + shutterVersion + ", firmwareVersion=" + firmwareVersion + '}';
    }

    
}
