package org.lsst.sal;

import java.time.Duration;
import java.util.concurrent.TimeoutException;

/**
 * A command response is returned whenever a command is issued. The command response
 * can be used to wait for the result.import static org.lsst.sal.SAL_camera.SAL__camera_ackcmd_ACTOR;

 * @author tonyj
 */
public abstract class SALCommandResponse {
    
    /**
     * Wait until either an ack or nack is received, or the command completes.
     * @param timeout The maximum time to wait
     * @return The expected duration of the command
     * @throws CommandFailedException If the command is rejected
     * @throws java.util.concurrent.TimeoutException If the wait times out
     */
    public abstract Duration waitForAck(Duration timeout) throws CommandFailedException, SALException, TimeoutException;
    /**
     * Wait until the command completes
     * @param timeout The maximum time to wait
     * @return The return code from the command
     * @throws CommandFailedException If the command fails or is rejected.  
     * @throws java.util.concurrent.TimeoutException   If the wait times out
     */
    public abstract int waitForCompletion(Duration timeout) throws CommandFailedException, SALException, TimeoutException;


    public static class CommandFailedException extends SALException implements SALHasErrorCode {

        private int ack;
        private int error;

        public CommandFailedException(String message, int ack, int error) {
            super(message);
            this.ack = ack;
            this.error = error;
        }

        @Override
        public int getErrorCode() {
            return error;
        }

        public int getAck() {
            return ack;
        }
    }
}
