/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;

public class TelemetrySendReceiveTest {
    private static SALCamera camera;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        camera = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        camera.close();
    }

    @Test
    public void sendColdTelemetry() throws InterruptedException, SALException, ExecutionException, TimeoutException {
    }

    @Test
    public void sendReceiveFilterTelemetry() throws InterruptedException, SALException, ExecutionException, TimeoutException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraTelemetry testTelemetrySendReceive(CameraTelemetry telemetry) throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<CameraTelemetry> future = executor.submit(() -> (CameraTelemetry)camera.getTelemetry(Duration.ofSeconds(10L)));
        try {
            CameraTelemetry result;
            camera.sendTelemetry((SALTelemetry)telemetry);
            CameraTelemetry cameraTelemetry = result = future.get(10L, TimeUnit.SECONDS);
            return cameraTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }
}

