/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.atcamera.telemetry.HeartbeatTelemetry;
import org.lsst.sal.atcamera.telemetry.WREBPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WREBTelemetry;
import org.lsst.sal.camera.CameraTelemetry;

public class TelemetrySendRecieveTest {
    private static ATCamera camera;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        camera = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        camera.close();
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraTelemetry telemetry = this.testTelemetrySendReceive((CameraTelemetry)new BonnShutterTelemetry(5.01f, 35.99f));
        Assert.assertTrue((boolean)(telemetry instanceof BonnShutterTelemetry));
        BonnShutterTelemetry shutterTelemetry = (BonnShutterTelemetry)telemetry;
        Assert.assertEquals((double)5.01, (double)shutterTelemetry.getShutter5V(), (double)0.001);
        Assert.assertEquals((double)35.99, (double)shutterTelemetry.getShutter36V(), (double)0.001);
    }

    @Test
    public void sendReceiveWREBPowerTelemetry() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraTelemetry telemetry = this.testTelemetrySendReceive((CameraTelemetry)new WREBPowerTelemetry(5.0f, 648.7f, 7.0f, 344.6f, 10.0f, 41.5f, 11.0f, 32.7f, 28.0f, 25.9f, 10.0f, 6.5f, 12.0f, 0.0f, 0.0f, 0.0f));
        Assert.assertTrue((boolean)(telemetry instanceof WREBPowerTelemetry));
        WREBPowerTelemetry powerTelemetry = (WREBPowerTelemetry)telemetry;
        Assert.assertEquals((double)5.0, (double)powerTelemetry.getDigital_V(), (double)0.01);
        Assert.assertEquals((double)648.7, (double)powerTelemetry.getDigital_I(), (double)0.01);
        Assert.assertEquals((double)7.0, (double)powerTelemetry.getAnalog_V(), (double)0.01);
        Assert.assertEquals((double)344.6, (double)powerTelemetry.getAnalog_I(), (double)0.01);
        Assert.assertEquals((double)10.0, (double)powerTelemetry.getClkHigh_V(), (double)0.01);
        Assert.assertEquals((double)41.5, (double)powerTelemetry.getClkHigh_I(), (double)0.01);
        Assert.assertEquals((double)11.0, (double)powerTelemetry.getClkLow_V(), (double)0.01);
        Assert.assertEquals((double)32.7, (double)powerTelemetry.getClkLow_I(), (double)0.01);
        Assert.assertEquals((double)28.0, (double)powerTelemetry.getOd_V(), (double)0.01);
        Assert.assertEquals((double)25.9, (double)powerTelemetry.getOd_I(), (double)0.01);
        Assert.assertEquals((double)10.0, (double)powerTelemetry.getDphi_V(), (double)0.01);
        Assert.assertEquals((double)6.5, (double)powerTelemetry.getDphi_I(), (double)0.01);
        Assert.assertEquals((double)12.0, (double)powerTelemetry.getHeater_V(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)powerTelemetry.getHeater_I(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)powerTelemetry.getHvbias_V(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)powerTelemetry.getHvbias_I(), (double)0.01);
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraTelemetry telemetry = this.testTelemetrySendReceive((CameraTelemetry)new HeartbeatTelemetry(true, 5));
        Assert.assertTrue((boolean)(telemetry instanceof HeartbeatTelemetry));
        HeartbeatTelemetry hbTelemetry = (HeartbeatTelemetry)telemetry;
        Assert.assertEquals((Object)true, (Object)hbTelemetry.isHeartbeat());
        Assert.assertEquals((double)5.0, (double)hbTelemetry.getPriority(), (double)0.1);
    }

    @Test
    public void sendRecieveWREBTelemetry() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraTelemetry telemetry = this.testTelemetrySendReceive((CameraTelemetry)new WREBTelemetry(1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 14.0f, 15.0f, 16.0f, 17.0f, 18.0f, 19.0f, 20.0f, 21.0f, 22.0f, 23.0f, 24.0f, 25.0f, 26.0f, 27.0f, 28.0f, 29.0f, 30.0f, 31.0f, 32.0f, 33.0f, 34.0f));
        Assert.assertTrue((boolean)(telemetry instanceof WREBTelemetry));
        WREBTelemetry wrebTelemetry = (WREBTelemetry)telemetry;
        Assert.assertEquals((double)1.0, (double)wrebTelemetry.getCkPSH_V(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)wrebTelemetry.getCkPOV(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)wrebTelemetry.getOgoV(), (double)0.1);
        Assert.assertEquals((double)4.0, (double)wrebTelemetry.getTemp1(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)wrebTelemetry.getTemp2(), (double)0.1);
        Assert.assertEquals((double)6.0, (double)wrebTelemetry.getTemp3(), (double)0.1);
        Assert.assertEquals((double)7.0, (double)wrebTelemetry.getTemp4(), (double)0.1);
        Assert.assertEquals((double)8.0, (double)wrebTelemetry.getTemp5(), (double)0.1);
        Assert.assertEquals((double)9.0, (double)wrebTelemetry.getTemp6(), (double)0.1);
        Assert.assertEquals((double)10.0, (double)wrebTelemetry.getAtemp0U(), (double)0.1);
        Assert.assertEquals((double)11.0, (double)wrebTelemetry.getAtemp0L(), (double)0.1);
        Assert.assertEquals((double)12.0, (double)wrebTelemetry.getCcdTemp0(), (double)0.1);
        Assert.assertEquals((double)14.0, (double)wrebTelemetry.getDigPS_V(), (double)0.1);
        Assert.assertEquals((double)15.0, (double)wrebTelemetry.getDigPS_I(), (double)0.1);
        Assert.assertEquals((double)16.0, (double)wrebTelemetry.getAnaPS_V(), (double)0.1);
        Assert.assertEquals((double)17.0, (double)wrebTelemetry.getAnaPS_I(), (double)0.1);
        Assert.assertEquals((double)18.0, (double)wrebTelemetry.getClkHPS_V(), (double)0.1);
        Assert.assertEquals((double)19.0, (double)wrebTelemetry.getClkHPS_I(), (double)0.1);
        Assert.assertEquals((double)20.0, (double)wrebTelemetry.getOdPS_V(), (double)0.1);
        Assert.assertEquals((double)21.0, (double)wrebTelemetry.getOdPS_I(), (double)0.1);
        Assert.assertEquals((double)22.0, (double)wrebTelemetry.getHtrPS_V(), (double)0.1);
        Assert.assertEquals((double)23.0, (double)wrebTelemetry.getHtrPS_I(), (double)0.1);
        Assert.assertEquals((double)24.0, (double)wrebTelemetry.getPower(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)wrebTelemetry.getSckU_V(), (double)0.1);
        Assert.assertEquals((double)26.0, (double)wrebTelemetry.getSckL_V(), (double)0.1);
        Assert.assertEquals((double)27.0, (double)wrebTelemetry.getRgU_V(), (double)0.1);
        Assert.assertEquals((double)28.0, (double)wrebTelemetry.getRgL_V(), (double)0.1);
        Assert.assertEquals((double)29.0, (double)wrebTelemetry.getCks0V(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)wrebTelemetry.getRg0V(), (double)0.1);
        Assert.assertEquals((double)31.0, (double)wrebTelemetry.getOd0V(), (double)0.1);
        Assert.assertEquals((double)32.0, (double)wrebTelemetry.getRd0V(), (double)0.1);
        Assert.assertEquals((double)33.0, (double)wrebTelemetry.getGd0V(), (double)0.1);
        Assert.assertEquals((double)34.0, (double)wrebTelemetry.getOd0I(), (double)0.1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraTelemetry testTelemetrySendReceive(CameraTelemetry telemetry) throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<CameraTelemetry> future = executor.submit(() -> (CameraTelemetry)camera.getTelemetry(Duration.ofSeconds(10L)));
        try {
            CameraTelemetry result;
            camera.sendTelemetry((SALTelemetry)telemetry);
            CameraTelemetry cameraTelemetry = result = future.get(10L, TimeUnit.SECONDS);
            return cameraTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }
}

