package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class CalibrationDetailedStateEvent extends CameraStateChangeEvent {

    public enum CalibrationState implements SALEnum<CalibrationState> {

        DISABLED, ENABLED, INTEGRATING
    };

    private final CalibrationState state;
   
    public CalibrationDetailedStateEvent(int priority, CalibrationState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public CalibrationState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "CalibrationDetailedStateEvent{" + "state=" + state + '}';
    }
}
