package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

/**
 *
 * @author Farrukh Azfar
 */
public class EndOfImageTelemetryEvent extends CameraEvent {
    
    private final String imageSequenceName;
    private final int imagesInSequence;
    private final String imageName;
    private final int imageIndex;
    private final double timeStampAcquisitionStart;
    private final double exposureTime; 
    private final String imageSource;
    private final String imageController;
    private final String imageDate;
    private final int imageNumber;

    public EndOfImageTelemetryEvent(int priority, String imageSequenceName, int imagesInSequence, String imageName, int imageIndex, 
            String imageSource, String imageController, String imageDate, int imageNumber,
            double timeStampAcquisitionStart, double exposureTime) {
        super(priority);
        this.imageSequenceName = imageSequenceName;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.imageIndex = imageIndex;
        this.imageSource = imageSource;
        this.imageController = imageController;
        this.imageDate = imageDate;
        this.imageNumber = imageNumber;
        this.timeStampAcquisitionStart = timeStampAcquisitionStart;
        this.exposureTime = exposureTime;
    }

    public String getImageName() {
        return imageName;
    }

    public String getImageSequenceName() {
        return imageSequenceName;
    }

    public int getImagesInSequence() {
        return imagesInSequence;
    }

    public int getImageIndex() {
        return imageIndex;
    }

    public double getTimeStampAcquisitionStart() {
        return timeStampAcquisitionStart;
    }

    public double getExposureTime() {
        return exposureTime;
    }

    public String getImageSource() {
        return imageSource;
    }

    public String getImageController() {
        return imageController;
    }

    public String getImageDate() {
        return imageDate;
    }

    public int getImageNumber() {
        return imageNumber;
    }

    @Override
    public String toString() {
        return "EndOfImageTelemetryEvent{" + "imageSequenceName=" + imageSequenceName + ", imagesInSequence=" + imagesInSequence + ", imageName=" + imageName + ", imageIndex=" + imageIndex + ", timeStampAcquisitionStart=" + timeStampAcquisitionStart + ", exposureTime=" + exposureTime + ", imageSource=" + imageSource + ", imageController=" + imageController + ", imageDate=" + imageDate + ", imageNumber=" + imageNumber + '}';
    }    
}
