/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import java.text.SimpleDateFormat;
import org.lsst.sal.camera.CameraEvent;

public class StartRaftIntegrationEvent
extends CameraEvent {
    private final String imageName;
    private final String imageSequenceName;
    private final int imagesInSequence;
    private final int imageIndex;
    private final double timeStampAcquisitionStart;
    private static final SimpleDateFormat DTF = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS");
    private final double exposureTime;

    public StartRaftIntegrationEvent(int priority, String imageSequenceName, int imagesInSequence, String imageName, int imageIndex, double timeStampAcquisitionStart, double exposureTime) {
        super(priority);
        this.imageSequenceName = imageSequenceName;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.imageIndex = imageIndex;
        this.timeStampAcquisitionStart = timeStampAcquisitionStart;
        this.exposureTime = exposureTime;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageSequenceName() {
        return this.imageSequenceName;
    }

    public int getImagesInSequence() {
        return this.imagesInSequence;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public double getTimeStampAcquisitionStart() {
        return this.timeStampAcquisitionStart;
    }

    public double getExposureTime() {
        return this.exposureTime;
    }

    public String toString() {
        return "StartRaftIntegrationEvent{imageName=" + this.imageName + ", imageSequenceName=" + this.imageSequenceName + ", imagesInSequence=" + this.imagesInSequence + ", imageIndex=" + this.imageIndex + ", timeStampAcquisitionStart=" + this.timeStampAcquisitionStart + ", exposureTime=" + this.exposureTime + '}';
    }

    static String toUTC(double timeStampAcquisitionStart) {
        return DTF.format((long)(timeStampAcquisitionStart / 1000.0));
    }
}

