/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRaftIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.CalibrationDetailedStateEvent;
import org.lsst.sal.camera.states.FilterChangerDetailedStateEvent;
import org.lsst.sal.camera.states.ImageReadinessDetailedStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.RaftsDetailedStateEvent;
import org.lsst.sal.camera.states.ShutterDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class EventSendReceiveTest {
    protected static SAL<CameraCommand, CameraEvent, CameraTelemetry> camera;
    protected static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        camera = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, Exception {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        camera.close();
    }

    @Test
    public void sendReceiveSummaryStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new SummaryStateEvent(1, SummaryStateEvent.LSE209State.ENABLED));
        Assert.assertTrue((boolean)(event instanceof SummaryStateEvent));
        SummaryStateEvent sse = (SummaryStateEvent)event;
        Assert.assertEquals((Object)SummaryStateEvent.LSE209State.ENABLED, (Object)sse.getSubstate());
        Assert.assertEquals((long)1L, (long)sse.getPriority());
        Assert.assertEquals((long)1L, (long)SummaryStateEvent.LSE209State.DISABLED.getSALValue());
        Assert.assertEquals((long)2L, (long)SummaryStateEvent.LSE209State.ENABLED.getSALValue());
        Assert.assertEquals((long)5L, (long)SummaryStateEvent.LSE209State.STANDBY.getSALValue());
        Assert.assertEquals((long)4L, (long)SummaryStateEvent.LSE209State.OFFLINE.getSALValue());
        Assert.assertEquals((long)3L, (long)SummaryStateEvent.LSE209State.FAULT.getSALValue());
    }

    @Test
    public void sendReceiveCCSCommandStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new CCSCommandStateEvent(1, CCSCommandStateEvent.IdleBusyState.BUSY));
        Assert.assertTrue((boolean)(event instanceof CCSCommandStateEvent));
        CCSCommandStateEvent detail = (CCSCommandStateEvent)event;
        Assert.assertEquals((Object)CCSCommandStateEvent.IdleBusyState.BUSY, (Object)detail.getSubstate());
        Assert.assertEquals((long)1L, (long)detail.getPriority());
        Assert.assertEquals((long)2L, (long)CCSCommandStateEvent.IdleBusyState.BUSY.getSALValue());
        Assert.assertEquals((long)1L, (long)CCSCommandStateEvent.IdleBusyState.IDLE.getSALValue());
    }

    @Test
    public void sendReceiveOfflineDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new OfflineDetailedStateEvent(11, OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY));
        Assert.assertTrue((boolean)(event instanceof OfflineDetailedStateEvent));
        OfflineDetailedStateEvent detail = (OfflineDetailedStateEvent)event;
        Assert.assertEquals((Object)OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY, (Object)detail.getSubstate());
        Assert.assertEquals((long)11L, (long)detail.getPriority());
        Assert.assertEquals((long)1L, (long)OfflineDetailedStateEvent.OfflineState.AVAILABLE.getSALValue());
        Assert.assertEquals((long)2L, (long)OfflineDetailedStateEvent.OfflineState.PUBLISH_ONLY.getSALValue());
    }

    @Test
    public void sendReceiveShutterDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new ShutterDetailedStateEvent(1, ShutterDetailedStateEvent.ShutterState.OPEN));
        Assert.assertTrue((boolean)(event instanceof ShutterDetailedStateEvent));
        ShutterDetailedStateEvent detail = (ShutterDetailedStateEvent)event;
        Assert.assertEquals((Object)ShutterDetailedStateEvent.ShutterState.OPEN, (Object)detail.getSubstate());
        Assert.assertEquals((long)1L, (long)detail.getPriority());
        Assert.assertEquals((long)1L, (long)ShutterDetailedStateEvent.ShutterState.CLOSED.getSALValue());
        Assert.assertEquals((long)2L, (long)ShutterDetailedStateEvent.ShutterState.OPEN.getSALValue());
        Assert.assertEquals((long)3L, (long)ShutterDetailedStateEvent.ShutterState.CLOSING.getSALValue());
        Assert.assertEquals((long)4L, (long)ShutterDetailedStateEvent.ShutterState.OPENING.getSALValue());
    }

    @Test
    public void sendReceiveImageReadinessDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new ImageReadinessDetailedStateEvent(19, ImageReadinessDetailedStateEvent.ImageReadinessState.GETTING_READY));
        Assert.assertTrue((boolean)(event instanceof ImageReadinessDetailedStateEvent));
        ImageReadinessDetailedStateEvent detail = (ImageReadinessDetailedStateEvent)event;
        Assert.assertEquals((Object)ImageReadinessDetailedStateEvent.ImageReadinessState.GETTING_READY, (Object)detail.getSubstate());
        Assert.assertEquals((long)19L, (long)detail.getPriority());
        Assert.assertEquals((long)2L, (long)ImageReadinessDetailedStateEvent.ImageReadinessState.NOT_READY.getSALValue());
        Assert.assertEquals((long)3L, (long)ImageReadinessDetailedStateEvent.ImageReadinessState.GETTING_READY.getSALValue());
        Assert.assertEquals((long)1L, (long)ImageReadinessDetailedStateEvent.ImageReadinessState.READY.getSALValue());
    }

    @Test
    public void sendReceiveFilterChangerDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new FilterChangerDetailedStateEvent(18, FilterChangerDetailedStateEvent.FilterChangerState.ROTATING));
        Assert.assertTrue((boolean)(event instanceof FilterChangerDetailedStateEvent));
        FilterChangerDetailedStateEvent detail = (FilterChangerDetailedStateEvent)event;
        Assert.assertEquals((Object)FilterChangerDetailedStateEvent.FilterChangerState.ROTATING, (Object)detail.getSubstate());
        Assert.assertEquals((long)18L, (long)detail.getPriority());
        Assert.assertEquals((long)3L, (long)FilterChangerDetailedStateEvent.FilterChangerState.LOADED.getSALValue());
        Assert.assertEquals((long)4L, (long)FilterChangerDetailedStateEvent.FilterChangerState.UNLOADED.getSALValue());
        Assert.assertEquals((long)2L, (long)FilterChangerDetailedStateEvent.FilterChangerState.LOADING.getSALValue());
        Assert.assertEquals((long)1L, (long)FilterChangerDetailedStateEvent.FilterChangerState.UNLOADING.getSALValue());
        Assert.assertEquals((long)5L, (long)FilterChangerDetailedStateEvent.FilterChangerState.ROTATING.getSALValue());
    }

    @Test
    public void sendReceiveCalibrationDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new CalibrationDetailedStateEvent(17, CalibrationDetailedStateEvent.CalibrationState.ENABLED));
        Assert.assertTrue((boolean)(event instanceof CalibrationDetailedStateEvent));
        CalibrationDetailedStateEvent detail = (CalibrationDetailedStateEvent)event;
        Assert.assertEquals((Object)CalibrationDetailedStateEvent.CalibrationState.ENABLED, (Object)detail.getSubstate());
        Assert.assertEquals((long)17L, (long)detail.getPriority());
        Assert.assertEquals((long)1L, (long)CalibrationDetailedStateEvent.CalibrationState.DISABLED.getSALValue());
        Assert.assertEquals((long)2L, (long)CalibrationDetailedStateEvent.CalibrationState.ENABLED.getSALValue());
        Assert.assertEquals((long)3L, (long)CalibrationDetailedStateEvent.CalibrationState.INTEGRATING.getSALValue());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartSetFilterEvent(16, "X-007"));
        Assert.assertTrue((boolean)(event instanceof StartSetFilterEvent));
        StartSetFilterEvent detail = (StartSetFilterEvent)event;
        Assert.assertEquals((Object)"X-007", (Object)detail.getFilterName());
        Assert.assertEquals((long)16L, (long)detail.getPriority());
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndSetFilterEvent(15, "Y-009"));
        Assert.assertTrue((boolean)(event instanceof EndSetFilterEvent));
        EndSetFilterEvent detail = (EndSetFilterEvent)event;
        Assert.assertEquals((Object)"Y-009", (Object)detail.getFilterName());
        Assert.assertEquals((long)15L, (long)detail.getPriority());
    }

    @Test
    public void sendReceiveRaftsDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new RaftsDetailedStateEvent(1, RaftsDetailedStateEvent.RaftsState.QUIESCENT));
        Assert.assertTrue((boolean)(event instanceof RaftsDetailedStateEvent));
        RaftsDetailedStateEvent detail = (RaftsDetailedStateEvent)event;
        Assert.assertEquals((Object)RaftsDetailedStateEvent.RaftsState.QUIESCENT, (Object)detail.getSubstate());
        Assert.assertEquals((long)1L, (long)detail.getPriority());
    }

    @Test
    public void sendReceiveStartRaftIntegrationEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartRaftIntegrationEvent(1, "eventSequenceName", 50, "eventName", 99, 500000.0001, 15.15));
        Assert.assertTrue((boolean)(event instanceof StartRaftIntegrationEvent));
        StartRaftIntegrationEvent srie = (StartRaftIntegrationEvent)event;
        Assert.assertEquals((Object)"eventSequenceName", (Object)srie.getImageSequenceName());
        Assert.assertEquals((Object)"eventName", (Object)srie.getImageName());
        Assert.assertEquals((long)99L, (long)srie.getImageIndex());
        Assert.assertEquals((double)500000.0001, (double)srie.getTimeStampAcquisitionStart(), (double)1.0E-12);
        Assert.assertEquals((double)15.15, (double)srie.getExposureTime(), (double)1.0E-12);
        Assert.assertEquals((long)50L, (long)srie.getImagesInSequence());
        Assert.assertEquals((long)1L, (long)srie.getPriority());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new AppliedSettingsMatchStartEvent(1, true));
        Assert.assertTrue((boolean)(event instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent se = (AppliedSettingsMatchStartEvent)event;
        Assert.assertTrue((boolean)se.isAppliedSettingsMatchStartIsTrue());
        Assert.assertEquals((long)1L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new AvailableFiltersEvent(13, "aLongListOfFilters"));
        Assert.assertTrue((boolean)(event instanceof AvailableFiltersEvent));
        AvailableFiltersEvent se = (AvailableFiltersEvent)event;
        Assert.assertEquals((Object)"aLongListOfFilters", (Object)se.getFilterNames());
        Assert.assertEquals((long)13L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartUnloadFilterEvent(12));
        Assert.assertTrue((boolean)(event instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent se = (StartUnloadFilterEvent)event;
        Assert.assertEquals((long)12L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndUnloadFilterEvent(11));
        Assert.assertTrue((boolean)(event instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent se = (EndUnloadFilterEvent)event;
        Assert.assertEquals((long)11L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartRotateCarouselEvent(10));
        Assert.assertTrue((boolean)(event instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent se = (StartRotateCarouselEvent)event;
        Assert.assertEquals((long)10L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndRotateCarouselEvent(9));
        Assert.assertTrue((boolean)(event instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent se = (EndRotateCarouselEvent)event;
        Assert.assertEquals((long)9L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartLoadFilterEvent(8));
        Assert.assertTrue((boolean)(event instanceof StartLoadFilterEvent));
        StartLoadFilterEvent se = (StartLoadFilterEvent)event;
        Assert.assertEquals((long)8L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndLoadFilterEvent(7));
        Assert.assertTrue((boolean)(event instanceof EndLoadFilterEvent));
        EndLoadFilterEvent se = (EndLoadFilterEvent)event;
        Assert.assertEquals((long)7L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartShutterOpenEvent(5));
        Assert.assertTrue((boolean)(event instanceof StartShutterOpenEvent));
        StartShutterOpenEvent se = (StartShutterOpenEvent)event;
        Assert.assertEquals((long)5L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndShutterOpenEvent(4));
        Assert.assertTrue((boolean)(event instanceof EndShutterOpenEvent));
        EndShutterOpenEvent se = (EndShutterOpenEvent)event;
        Assert.assertEquals((long)4L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartShutterCloseEvent(3));
        Assert.assertTrue((boolean)(event instanceof StartShutterCloseEvent));
        StartShutterCloseEvent se = (StartShutterCloseEvent)event;
        Assert.assertEquals((long)3L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndShutterCloseEvent(2));
        Assert.assertTrue((boolean)(event instanceof EndShutterCloseEvent));
        EndShutterCloseEvent se = (EndShutterCloseEvent)event;
        Assert.assertEquals((long)2L, (long)se.getPriority());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new StartReadoutEvent(1, "eventSequenceName", 50, "eventName", 99, 500000.0001, 15.15));
        Assert.assertTrue((boolean)(event instanceof StartReadoutEvent));
        StartReadoutEvent sr = (StartReadoutEvent)event;
        Assert.assertEquals((Object)"eventSequenceName", (Object)sr.getImageSequenceName());
        Assert.assertEquals((Object)"eventName", (Object)sr.getImageName());
        Assert.assertEquals((long)99L, (long)sr.getImageIndex());
        Assert.assertEquals((double)500000.0001, (double)sr.getTimeStampAcquisitionStart(), (double)1.0E-12);
        Assert.assertEquals((double)15.15, (double)sr.getExposureTime(), (double)1.0E-12);
        Assert.assertEquals((long)50L, (long)sr.getImagesInSequence());
        Assert.assertEquals((long)1L, (long)sr.getPriority());
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndReadoutEvent(1, "eventSequenceName", 50, "eventName", 99, 500000.0001, 15.15));
        Assert.assertTrue((boolean)(event instanceof EndReadoutEvent));
        EndReadoutEvent er = (EndReadoutEvent)event;
        Assert.assertEquals((Object)"eventSequenceName", (Object)er.getImageSequenceName());
        Assert.assertEquals((Object)"eventName", (Object)er.getImageName());
        Assert.assertEquals((long)99L, (long)er.getImageIndex());
        Assert.assertEquals((double)500000.0001, (double)er.getTimeStampAcquisitionStart(), (double)1.0E-12);
        Assert.assertEquals((double)15.15, (double)er.getExposureTime(), (double)1.0E-12);
        Assert.assertEquals((long)50L, (long)er.getImagesInSequence());
        Assert.assertEquals((long)1L, (long)er.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new EndOfImageTelemetryEvent(1, "eventSequenceName", 50, "eventName", 99, 500000.0001, 15.15));
        Assert.assertTrue((boolean)(event instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent eoite = (EndOfImageTelemetryEvent)event;
        Assert.assertEquals((Object)"eventSequenceName", (Object)eoite.getImageSequenceName());
        Assert.assertEquals((Object)"eventName", (Object)eoite.getImageName());
        Assert.assertEquals((long)99L, (long)eoite.getImageIndex());
        Assert.assertEquals((double)500000.0001, (double)eoite.getTimeStampAcquisitionStart(), (double)1.0E-12);
        Assert.assertEquals((double)15.15, (double)eoite.getExposureTime(), (double)1.0E-12);
        Assert.assertEquals((long)50L, (long)eoite.getImagesInSequence());
        Assert.assertEquals((long)1L, (long)eoite.getPriority());
    }

    @Test
    public void sendReceiveSettingsVersionsEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new SettingVersionsEvent(1, "myRandomSettings"));
        Assert.assertTrue((boolean)(event instanceof SettingVersionsEvent));
        SettingVersionsEvent sv = (SettingVersionsEvent)event;
        Assert.assertEquals((Object)"myRandomSettings", (Object)sv.getRecommendedSettingsVersion());
        Assert.assertEquals((long)1L, (long)sv.getPriority());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new SettingsAppliedEvent(55, "myRandomSettings"));
        Assert.assertTrue((boolean)(event instanceof SettingsAppliedEvent));
        SettingsAppliedEvent sv = (SettingsAppliedEvent)event;
        Assert.assertEquals((Object)"myRandomSettings", (Object)sv.getSettings());
        Assert.assertEquals((long)55L, (long)sv.getPriority());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new ErrorCodeEvent(33, 2001));
        Assert.assertTrue((boolean)(event instanceof ErrorCodeEvent));
        ErrorCodeEvent ec = (ErrorCodeEvent)event;
        Assert.assertEquals((long)2001L, (long)ec.getErrorCode());
        Assert.assertEquals((long)33L, (long)ec.getPriority());
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        int size = 201;
        int[] data = new int[size];
        Arrays.fill(data, 99999);
        Object[] sData = new ImageReadoutParametersEvent.CCDType[size];
        Arrays.fill(sData, ImageReadoutParametersEvent.CCDType.ITL);
        ImageReadoutParametersEvent irpe = new ImageReadoutParametersEvent(33, "test123", "sensors", (ImageReadoutParametersEvent.CCDType[])sData, data, data, data, data, data, data, data, data);
        CameraEvent event = this.testEventSendReceive((CameraEvent)irpe);
        Assert.assertTrue((boolean)(event instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent received = (ImageReadoutParametersEvent)event;
        Assert.assertEquals((Object)"test123", (Object)received.getImageName());
        Assert.assertEquals((long)33L, (long)received.getPriority());
        Assert.assertEquals((Object)ImageReadoutParametersEvent.CCDType.ITL, (Object)received.getCcdType()[100]);
        Assert.assertEquals((long)99999L, (long)received.getOverCols()[100]);
        Assert.assertEquals((long)2L, (long)ImageReadoutParametersEvent.CCDType.ITL.getSALValue());
        Assert.assertEquals((long)1L, (long)ImageReadoutParametersEvent.CCDType.E2V.getSALValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CameraEvent testEventSendReceive(CameraEvent event) throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<CameraEvent> future = executor.submit(() -> (CameraEvent)camera.getNextEvent(Duration.ofSeconds(10L)));
        try {
            CameraEvent result;
            Thread.sleep(100L);
            camera.logEvent((SALEvent)event);
            CameraEvent cameraEvent = result = future.get(10L, TimeUnit.SECONDS);
            return cameraEvent;
        }
        finally {
            future.cancel(true);
        }
    }
}

