/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SALException;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.BonnShutterSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.SettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.atcamera.event.WREBSettingsAppliedEvent;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;

public class EventSendReceiveTest
extends org.lsst.sal.camera.EventSendReceiveTest {
    @BeforeClass
    public static void setUpClass() {
        camera = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        camera.close();
    }

    @Override
    public void sendReceiveEndLoadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveEndLoadFilterEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveStartLoadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveStartLoadFilterEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveEndRotateCarouselEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveEndRotateCarouselEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveStartRotateCarouselEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveStartRotateCarouselEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveAvailableFiltersEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveAvailableFiltersEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveEndSetFilterEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveEndSetFilterEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveStartSetFilterEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveStartSetFilterEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveFilterChangerDetailedStateEvent() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveFilterChangerDetailedStateEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveEndUnloadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveEndUnloadFilterEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveStartUnloadFilterEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        try {
            super.sendReceiveStartUnloadFilterEvent();
            Assert.fail();
        }
        catch (SALException sALException) {
            // empty catch block
        }
    }

    @Override
    public void sendReceiveImageReadoutParametersEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        int size = 1;
        int[] data = new int[size];
        Arrays.fill(data, 99999);
        Object[] sData = new ImageReadoutParametersEvent.CCDType[size];
        Arrays.fill(sData, ImageReadoutParametersEvent.CCDType.ITL);
        ImageReadoutParametersEvent irpe = new ImageReadoutParametersEvent(33, "test123", "sensors", (ImageReadoutParametersEvent.CCDType[])sData, data, data, data, data, data, data, data, data);
        CameraEvent event = this.testEventSendReceive((CameraEvent)irpe);
        Assert.assertTrue((boolean)(event instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent received = (ImageReadoutParametersEvent)event;
        Assert.assertEquals((Object)"test123", (Object)received.getImageName());
        Assert.assertEquals((long)33L, (long)received.getPriority());
        Assert.assertEquals((Object)ImageReadoutParametersEvent.CCDType.ITL, (Object)received.getCcdType()[0]);
        Assert.assertEquals((long)99999L, (long)received.getOverCols()[0]);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new ShutterMotionProfileEvent(99, 99.99));
        Assert.assertTrue((boolean)(event instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent smpe = (ShutterMotionProfileEvent)event;
        Assert.assertEquals((long)99L, (long)smpe.getPriority());
        Assert.assertEquals((double)99.99, (double)smpe.getMeasuredExposureTime(), (double)100000.0);
    }

    @Test
    public void sendReceiveBonnShutterSettingsAppliedEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new BonnShutterSettingsAppliedEvent(11, 1, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, "beer", "wine"));
        Assert.assertTrue((boolean)(event instanceof BonnShutterSettingsAppliedEvent));
        BonnShutterSettingsAppliedEvent bsae = (BonnShutterSettingsAppliedEvent)event;
        Assert.assertEquals((long)1L, (long)bsae.getVersion());
        Assert.assertEquals((double)2.0, (double)bsae.getStartA(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)bsae.getStartB(), (double)0.1);
        Assert.assertEquals((double)4.0, (double)bsae.getTravelDistance(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)bsae.getStartVelocity(), (double)0.1);
        Assert.assertEquals((double)6.0, (double)bsae.getAcceleration(), (double)0.1);
        Assert.assertEquals((double)7.0, (double)bsae.getMaxVelocity(), (double)0.1);
        Assert.assertEquals((double)8.0, (double)bsae.getThreshold(), (double)0.1);
        Assert.assertEquals((Object)"beer", (Object)bsae.getShutterVersion());
        Assert.assertEquals((Object)"wine", (Object)bsae.getFirmwareVersion());
        Assert.assertEquals((long)11L, (long)bsae.getPriority());
    }

    @Override
    @Test
    public void sendReceiveSettingsAppliedEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new SettingsAppliedEvent(1, "ale", 1, "beer", "wine"));
        Assert.assertTrue((boolean)(event instanceof SettingsAppliedEvent));
        SettingsAppliedEvent sae = (SettingsAppliedEvent)event;
        Assert.assertEquals((long)1L, (long)sae.getPriority());
        Assert.assertEquals((long)1L, (long)sae.getVersion());
        Assert.assertEquals((Object)"ale", (Object)sae.getSettings());
        Assert.assertEquals((Object)"wine", (Object)sae.getBonnShutterSettingsVersion());
        Assert.assertEquals((Object)"beer", (Object)sae.getWrebSettingsVersion());
        Assert.assertEquals((long)1L, (long)sae.getPriority());
    }

    @Test
    public void sendReceiveWREBSettingsAppliedEvent() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        CameraEvent event = this.testEventSendReceive((CameraEvent)new WREBSettingsAppliedEvent(44, 1, "beer", 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43));
        Assert.assertTrue((boolean)(event instanceof WREBSettingsAppliedEvent));
        WREBSettingsAppliedEvent wsae = (WREBSettingsAppliedEvent)event;
        Assert.assertEquals((long)44L, (long)wsae.getPriority());
        Assert.assertEquals((long)1L, (long)wsae.getVersion());
        Assert.assertEquals((Object)"beer", (Object)wsae.getSequencerKey());
        Assert.assertEquals((long)2L, (long)wsae.getDaqVersion());
        Assert.assertEquals((long)3L, (long)wsae.getFirmwareVersion());
        Assert.assertEquals((long)4L, (long)wsae.getAspic0_af1());
        Assert.assertEquals((long)5L, (long)wsae.getAspic0_clamp());
        Assert.assertEquals((long)6L, (long)wsae.getAspic0_gain());
        Assert.assertEquals((long)7L, (long)wsae.getAspic0_rc());
        Assert.assertEquals((long)8L, (long)wsae.getAspic0_tm());
        Assert.assertEquals((long)9L, (long)wsae.getAspic1_af1());
        Assert.assertEquals((long)10L, (long)wsae.getAspic1_clamp());
        Assert.assertEquals((long)11L, (long)wsae.getAspic1_gain());
        Assert.assertEquals((long)12L, (long)wsae.getAspic1_rc());
        Assert.assertEquals((long)13L, (long)wsae.getAspic1_tm());
        Assert.assertEquals((long)14L, (long)wsae.getBias0_csGate());
        Assert.assertEquals((long)15L, (long)wsae.getBias0_csGateP());
        Assert.assertEquals((long)16L, (long)wsae.getBias0_gd());
        Assert.assertEquals((long)17L, (long)wsae.getBias0_gdP());
        Assert.assertEquals((long)18L, (long)wsae.getBias0_od());
        Assert.assertEquals((long)19L, (long)wsae.getBias0_odP());
        Assert.assertEquals((long)20L, (long)wsae.getBias0_og());
        Assert.assertEquals((long)21L, (long)wsae.getBias0_ogP());
        Assert.assertEquals((long)22L, (long)wsae.getBias0_ogSh());
        Assert.assertEquals((long)23L, (long)wsae.getBias0_rd());
        Assert.assertEquals((long)24L, (long)wsae.getBias0_rdP());
        Assert.assertEquals((long)25L, (long)wsae.getDac_csGate());
        Assert.assertEquals((long)26L, (long)wsae.getDac_pclkHigh());
        Assert.assertEquals((long)27L, (long)wsae.getDac_pclkHighP());
        Assert.assertEquals((long)28L, (long)wsae.getDac_pclkHighSh());
        Assert.assertEquals((long)29L, (long)wsae.getDac_pclkLow());
        Assert.assertEquals((long)30L, (long)wsae.getDac_pclkLowP());
        Assert.assertEquals((long)31L, (long)wsae.getDac_pclkLowSh());
        Assert.assertEquals((long)32L, (long)wsae.getDac_rgHigh());
        Assert.assertEquals((long)33L, (long)wsae.getDac_rgHighP());
        Assert.assertEquals((long)34L, (long)wsae.getDac_rgHighSh());
        Assert.assertEquals((long)35L, (long)wsae.getDac_rgLow());
        Assert.assertEquals((long)36L, (long)wsae.getDac_rgLowP());
        Assert.assertEquals((long)37L, (long)wsae.getDac_rgLowSh());
        Assert.assertEquals((long)38L, (long)wsae.getDac_sclkHigh());
        Assert.assertEquals((long)39L, (long)wsae.getDac_sclkHighP());
        Assert.assertEquals((long)40L, (long)wsae.getDac_sclkHighSh());
        Assert.assertEquals((long)41L, (long)wsae.getDac_sclkLow());
        Assert.assertEquals((long)42L, (long)wsae.getDac_sclkLowP());
        Assert.assertEquals((long)43L, (long)wsae.getDac_sclkLowSh());
    }
}

