package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class RaftsDetailedStateEvent extends CameraStateChangeEvent {

    public enum RaftsState  implements SALEnum<RaftsState> {

        NEEDS_CLEAR, CLEARING, INTEGRATING, READING_OUT, QUIESCENT
    };

    private final RaftsState state;
   
    public RaftsDetailedStateEvent(int priority, RaftsState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public RaftsState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "RaftsDetailedStateEvent{" + "state=" + state + '}';
    }
}
