package org.lsst.sal.camera.event;

import java.text.SimpleDateFormat;
import org.lsst.sal.camera.CameraEvent;

/**
 * Start Integration event.
 *
 * @author tonyj
 */
public class StartRaftIntegrationEvent extends CameraEvent {

    private final String imageName;
    private final String imageSequenceName;
    private final int imagesInSequence;
    private final int imageIndex;
    private final double timeStampAcquisitionStart;
    private final static SimpleDateFormat DTF = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS");
    private final double exposureTime;

    public StartRaftIntegrationEvent(int priority, String imageSequenceName, int imagesInSequence, String imageName, int imageIndex, double timeStampAcquisitionStart, double exposureTime) {
        super(priority);
        this.imageSequenceName = imageSequenceName;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.imageIndex = imageIndex;
        this.timeStampAcquisitionStart = timeStampAcquisitionStart;
        this.exposureTime = exposureTime;
    }

    public String getImageName() {
        return imageName;
    }

    public String getImageSequenceName() {
        return imageSequenceName;
    }

    public int getImagesInSequence() {
        return imagesInSequence;
    }

    public int getImageIndex() {
        return imageIndex;
    }

    public double getTimeStampAcquisitionStart() {
        return timeStampAcquisitionStart;
    }

    public double getExposureTime() {
        return exposureTime;
    }

    @Override
    public String toString() {
        return "StartRaftIntegrationEvent{" + "imageName=" + imageName + ", imageSequenceName=" + imageSequenceName + ", imagesInSequence=" + imagesInSequence + ", imageIndex=" + imageIndex + ", timeStampAcquisitionStart=" + timeStampAcquisitionStart + ", exposureTime=" + exposureTime + '}';
    }

    static String toUTC(double timeStampAcquisitionStart) {
        return DTF.format((long) (timeStampAcquisitionStart/1000.0));
    }

}
