/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal;

import DDS.SampleInfoSeqHolder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;

class CommandHelper {
    private final Object manager;
    private final Class ackcmdSeqHolder;
    private final int debugLevel = 0;
    private final Method getReader2Method;
    private final int cmdInProgress;
    private final int cmdComplete;
    private final int cmdNoAck;
    private final int cmdAckcmdActor;
    private final Field valueField;
    private final Class<?> valueType;
    private final Field ackField;
    private final Field errorField;
    private final Field resultField;
    private Field seqnumField;

    CommandHelper(Object manager) throws ReflectiveOperationException {
        this.manager = manager;
        Class<?> managerClass = manager.getClass();
        Method[] methods = managerClass.getMethods();
        Class<?> localAckcmdSeqHolder = null;
        for (Method method : methods) {
            if (!method.getName().startsWith("getResponse")) continue;
            localAckcmdSeqHolder = method.getParameterTypes()[0];
            break;
        }
        if (localAckcmdSeqHolder == null) {
            throw new NoSuchMethodException("getResponse");
        }
        this.ackcmdSeqHolder = localAckcmdSeqHolder;
        this.getReader2Method = managerClass.getMethod("getReader2", Integer.TYPE);
        this.cmdInProgress = managerClass.getField("SAL__CMD_INPROGRESS").getInt(manager);
        this.cmdComplete = managerClass.getField("SAL__CMD_COMPLETE").getInt(manager);
        this.cmdNoAck = managerClass.getField("SAL__CMD_NOACK").getInt(manager);
        int localcmdAckcmdActor = -1;
        for (Field field : managerClass.getFields()) {
            if (!field.getName().endsWith("ackcmd_ACTOR")) continue;
            localcmdAckcmdActor = field.getInt(manager);
            break;
        }
        if (localcmdAckcmdActor == -1) {
            throw new NoSuchFieldException("ackcmd_ACTOR");
        }
        this.cmdAckcmdActor = localcmdAckcmdActor;
        this.valueField = this.ackcmdSeqHolder.getField("value");
        this.valueType = this.valueField.getType().getComponentType();
        this.ackField = this.valueType.getField("ack");
        this.errorField = this.valueType.getField("error");
        this.resultField = this.valueType.getField("result");
        this.seqnumField = this.valueType.getField("private_seqNum");
    }

    int waitForCompletion(int cmdId, int timeout) throws SALException, TimeoutException {
        try {
            Object ackcmd = this.ackcmdSeqHolder.newInstance();
            UsefulResponse useful = new UsefulResponse();
            long timeoutTime = System.currentTimeMillis() + (long)(timeout * 1000);
            while (true) {
                int status;
                if ((status = this.getResponseInternal(cmdId, ackcmd, useful)) == this.cmdComplete) {
                    return status;
                }
                if (timeoutTime < System.currentTimeMillis()) break;
                Thread.sleep(10L);
            }
            throw new TimeoutException("waitForCompletion timed out");
        }
        catch (InterruptedException | ReflectiveOperationException x) {
            throw new SALException("Error waiting for command response", x);
        }
    }

    Duration waitForAck(int cmdId, int timeout) throws SALCommandResponse.CommandFailedException, TimeoutException, SALException {
        try {
            Object ackcmd = this.ackcmdSeqHolder.newInstance();
            UsefulResponse useful = new UsefulResponse();
            long timeoutTime = System.currentTimeMillis() + (long)(timeout * 1000);
            while (true) {
                int status;
                if ((status = this.getResponseInternal(cmdId, ackcmd, useful)) == this.cmdInProgress) {
                    return Duration.ofSeconds(useful.error);
                }
                if (status == this.cmdComplete) {
                    return Duration.ZERO;
                }
                if (timeoutTime < System.currentTimeMillis()) break;
                Thread.sleep(10L);
            }
            throw new TimeoutException("waitForAck timed out");
        }
        catch (InterruptedException | ReflectiveOperationException x) {
            throw new SALException("Error waiting for command ack", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getResponseInternal(int cmdId, Object data, UsefulResponse useful) throws ReflectiveOperationException, SALCommandResponse.CommandFailedException {
        SampleInfoSeqHolder infoSeq;
        Method returnMethod;
        Object dreader;
        block4: {
            int n;
            dreader = this.getReader2Method.invoke(this.manager, this.cmdAckcmdActor);
            Method takeMethod = dreader.getClass().getMethod("take", data.getClass(), SampleInfoSeqHolder.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            returnMethod = dreader.getClass().getMethod("return_loan", data.getClass(), SampleInfoSeqHolder.class);
            infoSeq = new SampleInfoSeqHolder();
            takeMethod.invoke(dreader, data, infoSeq, 1, 65535, 65535, 65535);
            try {
                Object value = this.valueField.get(data);
                if (value == null || Array.getLength(value) <= 0) break block4;
                int status = this.cmdNoAck;
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object v = Array.get(value, i);
                    int seqnum = this.seqnumField.getInt(v);
                    if (seqnum != cmdId) continue;
                    useful.ack = this.ackField.getInt(v);
                    useful.error = this.errorField.getInt(v);
                    useful.result = (String)this.resultField.get(v);
                    status = useful.ack;
                    if (status >= 0) continue;
                    throw new SALCommandResponse.CommandFailedException(useful.result, useful.ack, useful.error);
                }
                n = status;
            }
            catch (Throwable throwable) {
                returnMethod.invoke(dreader, data, infoSeq);
                throw throwable;
            }
            returnMethod.invoke(dreader, data, infoSeq);
            return n;
        }
        int n = this.cmdNoAck;
        returnMethod.invoke(dreader, data, infoSeq);
        return n;
    }

    private static class UsefulResponse {
        private int ack;
        private int error;
        private String result;

        private UsefulResponse() {
        }
    }
}

