/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;
import org.lsst.sal.SALHasErrorCode;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

public class CommandSendReceiveTest {
    protected static SAL<CameraCommand, CameraEvent, CameraTelemetry> camera;
    protected static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        camera = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        camera.close();
    }

    @Test
    public void sendReceiveEnableCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new EnableCommand());
        Assert.assertTrue((boolean)(command instanceof EnableCommand));
    }

    @Test
    public void sendReceiveDisableCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new DisableCommand());
        Assert.assertTrue((boolean)(command instanceof DisableCommand));
    }

    @Test
    public void sendReceiveEnterControlCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new EnterControlCommand());
        Assert.assertTrue((boolean)(command instanceof EnterControlCommand));
    }

    @Test
    public void sendReceiveExitControlCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new ExitControlCommand());
        Assert.assertTrue((boolean)(command instanceof ExitControlCommand));
    }

    @Test
    public void sendReceiveEnableCalibrationCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new EnableCalibrationCommand());
        Assert.assertTrue((boolean)(command instanceof EnableCalibrationCommand));
    }

    @Test
    public void sendReceiveDisableCalibrationCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new DisableCalibrationCommand());
        Assert.assertTrue((boolean)(command instanceof DisableCalibrationCommand));
    }

    @Test
    public void sendReceiveStartCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new StartCommand("configuration"));
        Assert.assertTrue((boolean)(command instanceof StartCommand));
        StartCommand sc = (StartCommand)command;
        Assert.assertEquals((Object)"configuration", (Object)sc.getSettingsToApply());
    }

    @Test
    public void sendReceiveStandbyCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new StandbyCommand());
        Assert.assertTrue((boolean)(command instanceof StandbyCommand));
    }

    @Test
    public void sendTakeImagesCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new TakeImagesCommand(10.0, 2, true, true, true, true, "MyImage"));
        Assert.assertTrue((boolean)(command instanceof TakeImagesCommand));
        TakeImagesCommand tic = (TakeImagesCommand)command;
        Assert.assertEquals((long)2L, (long)tic.getNumImages());
        Assert.assertEquals((double)10.0, (double)tic.getExpTime(), (double)1.0E-6);
        Assert.assertTrue((boolean)tic.isShutter());
        Assert.assertTrue((boolean)tic.isScience());
        Assert.assertTrue((boolean)tic.isGuide());
        Assert.assertTrue((boolean)tic.isWfs());
        Assert.assertEquals((Object)"MyImage", (Object)tic.getImageSequenceName());
    }

    @Test
    public void sendReceiveSetFilterCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new SetFilterCommand("filterAAA"));
        Assert.assertTrue((boolean)(command instanceof SetFilterCommand));
        SetFilterCommand sf = (SetFilterCommand)command;
        Assert.assertEquals((Object)"filterAAA", (Object)sf.getName());
    }

    @Test
    public void sendReceiveInitImageCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new InitImageCommand(1.234));
        Assert.assertTrue((boolean)(command instanceof InitImageCommand));
        InitImageCommand sf = (InitImageCommand)command;
        Assert.assertEquals((double)1.234, (double)sf.getDeltaT(), (double)1.0E-6);
    }

    @Test
    public void sendReceiveInitGuidersCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new InitGuidersCommand("roiSpec"));
        Assert.assertTrue((boolean)(command instanceof InitGuidersCommand));
        InitGuidersCommand ig = (InitGuidersCommand)command;
        Assert.assertEquals((Object)"roiSpec", (Object)ig.getRoiSpec());
    }

    @Test
    public void sendReceiveClearCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new ClearCommand(19));
        Assert.assertTrue((boolean)(command instanceof ClearCommand));
        ClearCommand clear = (ClearCommand)command;
        Assert.assertEquals((long)19L, (long)clear.getNClears());
    }

    @Test
    public void sendReceiveStartImageCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new StartImageCommand("bananas", true, true, true, true, 33.0));
        Assert.assertTrue((boolean)(command instanceof StartImageCommand));
        StartImageCommand start = (StartImageCommand)command;
        Assert.assertEquals((Object)"bananas", (Object)start.getImageSequenceName());
        Assert.assertTrue((boolean)start.isShutter());
        Assert.assertTrue((boolean)start.isScience());
        Assert.assertTrue((boolean)start.isWfs());
        Assert.assertTrue((boolean)start.isGuide());
        Assert.assertEquals((double)33.0, (double)start.getTimeout(), (double)1.0E-6);
    }

    @Test
    public void sendReceiveEndImageCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new EndImageCommand());
        Assert.assertTrue((boolean)(command instanceof EndImageCommand));
    }

    @Test
    public void sendReceiveDiscardRowsCommand() throws InterruptedException, SALException, ExecutionException, TimeoutException {
        CameraCommand command = this.testCommandSendReceive((CameraCommand)new DiscardRowsCommand(25));
        Assert.assertTrue((boolean)(command instanceof DiscardRowsCommand));
        DiscardRowsCommand discard = (DiscardRowsCommand)command;
        Assert.assertEquals((long)25L, (long)discard.getNRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandFailTest() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)new DiscardRowsCommand(25));
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.reportError((Exception)new CommandFailedException());
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.fail((String)("Unexpected response " + rc));
        }
        catch (SALCommandResponse.CommandFailedException x) {
            Assert.assertEquals((long)1999L, (long)x.getErrorCode());
            Assert.assertTrue((boolean)x.getMessage().contains("Command Failed"));
        }
        finally {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandRejectTest() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)new DiscardRowsCommand(25));
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.rejectCommand("Because I say so", 2001);
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.fail((String)("Unexpected response " + rc));
        }
        catch (SALCommandResponse.CommandFailedException x) {
            Assert.assertEquals((long)2001L, (long)x.getErrorCode());
            Assert.assertTrue((boolean)x.getMessage().contains("Because"));
        }
        finally {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandTimeoutTest() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)new DiscardRowsCommand(25));
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.fail((String)("Unexpected response " + rc));
        }
        catch (TimeoutException timeoutException) {
        }
        finally {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandAckTest() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)new DiscardRowsCommand(25));
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.acknowledgeCommand(Duration.ofSeconds(10L));
            Duration duration = response.waitForAck(Duration.ofSeconds(1L));
            Assert.assertEquals((long)10L, (long)duration.getSeconds());
            result.reportComplete();
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.assertEquals((long)303L, (long)rc);
        }
        finally {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandMissingAckTest() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)new DiscardRowsCommand(25));
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.reportComplete();
            Duration duration = response.waitForAck(Duration.ofSeconds(1L));
            Assert.assertEquals((long)0L, (long)duration.getSeconds());
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.assertEquals((long)303L, (long)rc);
        }
        finally {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandRejectAckTest() throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)new DiscardRowsCommand(25));
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.rejectCommand("Just because", 999);
            Duration duration = response.waitForAck(Duration.ofSeconds(1L));
            Assert.fail((String)"Missing exception");
        }
        catch (SALCommandResponse.CommandFailedException x) {
            Assert.assertEquals((long)999L, (long)x.getErrorCode());
        }
        finally {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraCommand testCommandSendReceive(CameraCommand command) throws SALException, InterruptedException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> camera.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = camera.issueCommand((SALCommand)command);
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.acknowledgeCommand(Duration.ofSeconds(3L));
            result.reportComplete();
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.assertEquals((long)303L, (long)rc);
            CameraCommand cameraCommand = (CameraCommand)result.getCommand();
            return cameraCommand;
        }
        finally {
            future.cancel(true);
        }
    }

    private static class CommandFailedException
    extends Exception
    implements SALHasErrorCode {
        public CommandFailedException() {
            super("Command Failed");
        }

        public int getErrorCode() {
            return 1999;
        }
    }
}

