package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

/**
 * Available filters event.
 *
 * @author tonyj
 */
public class AvailableFiltersEvent extends CameraEvent {

    private final String availableFilters;

    public AvailableFiltersEvent(int priority, String availableFilters) {
        super(priority);
        this.availableFilters = availableFilters;
    }

    public String getFilterNames() {
        return availableFilters;
    }

    @Override
    public String toString() {
        return "AvailableFiltersEvent{" + "availableFilters=" + availableFilters + '}';
    }

}
