package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

/**
 *
 * @author Farrukh Azfar
 */
public class WREBTelemetry extends CameraTelemetry {

    private final float CKPSH_V; //0
    private final float CKPOV; //1 // change O -> 0 (third slot : letter O to numeral 0)
    private final float OGOV; //2 change O -> 0 (third slot : letter O to zero in xml) and here in code.
    private final float Temp1; //3
    private final float Temp2; //4
    private final float Temp3; //5
    private final float Temp4; //6
    private final float Temp5; //7
    private final float Temp6; //8
    private final float Atemp0U; //9
    private final float Atemp0L; //10
    private final float CCDtemp0; //11
    private final float RTDtemp; //12
    private final float DigPS_V; //13
    private final float DigPS_I; //14
    private final float AnaPS_V; //15
    private final float AnaPS_I; //16
    private final float ClkHPS_V; //17
    private final float ClkHPS_I; //18
    private final float ODPS_V; //19
    private final float ODPS_I; //20
    private final float HtrPS_V; //21
    private final float HtrPS_I; //22
    private final float Power; //23
    private final float SCKU_V; //24
    private final float SCKL_V; //25
    private final float RGU_V; //26
    private final float RGL_V; //27
    private final float CKS0V; //28
    private final float RG0V; //29
    private final float OD0V; //30
    private final float RD0V; //31
    private final float GD0V; //32
    private final float OD0I; //33

    public WREBTelemetry(float CKPSH_V, float CKPOV, float OGOV, float Temp1, float Temp2, float Temp3, float Temp4, float Temp5, float Temp6, float Atemp0U, float Atemp0L, float CCDtemp0, float RTDtemp, float DigPS_V, float DigPS_I, float AnaPS_V, float AnaPS_I, float ClkHPS_V, float ClkHPS_I, float ODPS_V, float ODPS_I, float HtrPS_V, float HtrPS_I, float Power, float SCKU_V, float SCKL_V, float RGU_V, float RGL_V, float CKS0V, float RG0V, float OD0V, float RD0V, float GD0V, float OD0I) {
        this.CKPSH_V = CKPSH_V;
        this.CKPOV = CKPOV;
        this.OGOV = OGOV;
        this.Temp1 = Temp1;
        this.Temp2 = Temp2;
        this.Temp3 = Temp3;
        this.Temp4 = Temp4;
        this.Temp5 = Temp5;
        this.Temp6 = Temp6;
        this.Atemp0U = Atemp0U;
        this.Atemp0L = Atemp0L;
        this.CCDtemp0 = CCDtemp0;
        this.RTDtemp = RTDtemp;
        this.DigPS_V = DigPS_V;
        this.DigPS_I = DigPS_I;
        this.AnaPS_V = AnaPS_V;
        this.AnaPS_I = AnaPS_I;
        this.ClkHPS_V = ClkHPS_V;
        this.ClkHPS_I = ClkHPS_I;
        this.ODPS_V = ODPS_V;
        this.ODPS_I = ODPS_I;
        this.HtrPS_V = HtrPS_V;
        this.HtrPS_I = HtrPS_I;
        this.Power = Power;
        this.SCKU_V = SCKU_V;
        this.SCKL_V = SCKL_V;
        this.RGU_V = RGU_V;
        this.RGL_V = RGL_V;
        this.CKS0V = CKS0V;
        this.RG0V = RG0V;
        this.OD0V = OD0V;
        this.RD0V = RD0V;
        this.GD0V = GD0V;
        this.OD0I = OD0I;
    }

    public float getCkPSH_V() {
        return CKPSH_V;
    }

    public float getCkPOV() {
        return CKPOV;
    }

    public float getOgoV() {
        return OGOV;
    }

    public float getTemp1() {
        return Temp1;
    }

    public float getTemp2() {
        return Temp2;
    }

    public float getTemp3() {
        return Temp3;
    }

    public float getTemp4() {
        return Temp4;
    }

    public float getTemp5() {
        return Temp5;
    }

    public float getTemp6() {
        return Temp6;
    }

    public float getAtemp0U() {
        return Atemp0U;
    }

    public float getAtemp0L() {
        return Atemp0L;
    }

    public float getCcdTemp0() {
        return CCDtemp0;
    }

    public float getRtdTemp() {
        return RTDtemp;
    }

    public float getDigPS_V() {
        return DigPS_V;
    }

    public float getDigPS_I() {
        return DigPS_I;
    }

    public float getAnaPS_V() {
        return AnaPS_V;
    }

    public float getAnaPS_I() {
        return AnaPS_I;
    }

    public float getClkHPS_V() {
        return ClkHPS_V;
    }

    public float getClkHPS_I() {
        return ClkHPS_I;
    }

    public float getOdPS_V() {
        return ODPS_V;
    }

    public float getOdPS_I() {
        return ODPS_I;
    }

    public float getHtrPS_V() {
        return HtrPS_V;
    }

    public float getHtrPS_I() {
        return HtrPS_I;
    }

    public float getPower() {
        return Power;
    }

    public float getSckU_V() {
        return SCKU_V;
    }

    public float getSckL_V() {
        return SCKL_V;
    }

    public float getRgU_V() {
        return RGU_V;
    }

    public float getRgL_V() {
        return RGL_V;
    }

    public float getCks0V() {
        return CKS0V;
    }

    public float getRg0V() {
        return RG0V;
    }

    public float getOd0V() {
        return OD0V;
    }

    public float getRd0V() {
        return RD0V;
    }

    public float getGd0V() {
        return GD0V;
    }

    public float getOd0I() {
        return OD0I;
    }

    @Override
    public String toString() {
        return "WREBTelemetry{" + "CKPSH_V=" + CKPSH_V + ", CKPOV=" + CKPOV + ", OGOV=" + OGOV + ", Temp1=" + Temp1 + ", Temp2=" + Temp2 + ", Temp3=" + Temp3 + ", Temp4=" + Temp4 + ", Temp5=" + Temp5 + ", Temp6=" + Temp6 + ", Atemp0U=" + Atemp0U + ", Atemp0L=" + Atemp0L + ", CCDtemp0=" + CCDtemp0 + ", RTDtemp=" + RTDtemp + ", DigPS_V=" + DigPS_V + ", DigPS_I=" + DigPS_I + ", AnaPS_V=" + AnaPS_V + ", AnaPS_I=" + AnaPS_I + ", ClkHPS_V=" + ClkHPS_V + ", ClkHPS_I=" + ClkHPS_I + ", ODPS_V=" + ODPS_V + ", ODPS_I=" + ODPS_I + ", HtrPS_V=" + HtrPS_V + ", HtrPS_I=" + HtrPS_I + ", Power=" + Power + ", SCKU_V=" + SCKU_V + ", SCKL_V=" + SCKL_V + ", RGU_V=" + RGU_V + ", RGL_V=" + RGL_V + ", CKS0V=" + CKS0V + ", RG0V=" + RG0V + ", OD0V=" + OD0V + ", RD0V=" + RD0V + ", GD0V=" + GD0V + ", OD0I=" + OD0I + '}';
    }
    
    
    
    

}
