/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import java.text.SimpleDateFormat;
import org.lsst.sal.camera.CameraEvent;

public class StartRaftIntegrationEvent
extends CameraEvent {
    private final String imageName;
    private final String imageSequenceName;
    private final int imagesInSequence;
    private final int imageIndex;
    private final double timeStamp;
    private static final SimpleDateFormat DTF = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS");
    private final double exposureTime;

    public StartRaftIntegrationEvent(int priority, String imageSequenceName, int imagesInSequence, String imageName, int imageIndex, double timeStamp, double exposureTime) {
        super(priority);
        this.imageSequenceName = imageSequenceName;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.imageIndex = imageIndex;
        this.timeStamp = timeStamp;
        this.exposureTime = exposureTime;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageSequenceName() {
        return this.imageSequenceName;
    }

    public int getImagesInSequence() {
        return this.imagesInSequence;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public double getTimeStamp() {
        return this.timeStamp;
    }

    public double getExposureTime() {
        return this.exposureTime;
    }

    public String toString() {
        return "StartRaftIntegrationEvent{imageName=" + this.imageName + ", imageSequenceName=" + this.imageSequenceName + ", imagesInSequence=" + this.imagesInSequence + ", imageIndex=" + this.imageIndex + ", timeStamp=" + this.timeStamp + ", exposureTime=" + this.exposureTime + '}';
    }

    static String toUTC(double timeStamp) {
        return DTF.format((long)(timeStamp / 1000.0));
    }
}

