package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class OfflineDetailedStateEvent extends CameraStateChangeEvent {

    public enum OfflineState implements SALEnum<OfflineState> {

        PUBLISH_ONLY(MTCamera.offlineDetailedState_OFFLINE_PUBLISH_ONLY.value), 
        AVAILABLE(MTCamera.offlineDetailedState_OFFLINE_AVAILABLE.value);

        private final int salValue;
        
        OfflineState(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
    };

    private final OfflineState state;
    
    public OfflineDetailedStateEvent(int priority, OfflineState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public OfflineState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "OfflineDetailedStateEvent{" + "state=" + state + '}';
    }

}
