package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

/**
 *
 * @author Farrukh Azfar
 */
public class SettingsAppliedEvent extends CameraEvent {

    private final String settings;
    private final int version;
    private final String WREBSettingsVersion;
    private final String BonnShutterSettingsVersion;

    public SettingsAppliedEvent(int priority, String settings, int version, String WREBSettingsVersion, String BonnShutterSettingsVersion) {
        super(priority);
        this.settings = settings;
        this.version = version;
        this.WREBSettingsVersion = WREBSettingsVersion;
        this.BonnShutterSettingsVersion = BonnShutterSettingsVersion;
    }

    public String getSettings() {
        return settings;
    }

    public int getVersion() {
        return version;
    }

    public String getWrebSettingsVersion() {
        return WREBSettingsVersion;
    }

    public String getBonnShutterSettingsVersion() {
        return BonnShutterSettingsVersion;
    }

    @Override
    public String toString() {
        return "SettingsAppliedEvent{" + "settings=" + settings + ", version=" + version + ", WREBSettingsVersion=" + WREBSettingsVersion + ", BonnShutterSettingsVersion=" + BonnShutterSettingsVersion + '}';
    }

}
