package org.lsst.sal.camera.states;

// TODO: These are currently only available for atcamera, we should be using camera 
import atcamera.summaryState_DisabledState;
import atcamera.summaryState_EnabledState;
import atcamera.summaryState_FaultState;
import atcamera.summaryState_OfflineState;
import atcamera.summaryState_StandbyState;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 * The SummaryStateEvent (for LSE209 state changes)
 * @author tonyj
 */
public class SummaryStateEvent extends CameraStateChangeEvent {

    private final LSE209State state;

    public enum LSE209State implements SALEnum<LSE209State> {
        OFFLINE(summaryState_OfflineState.value), 
        STANDBY(summaryState_StandbyState.value), 
        DISABLED(summaryState_DisabledState.value), 
        ENABLED(summaryState_EnabledState.value), 
        FAULT(summaryState_FaultState.value);

        private final int salValue;
        
        private LSE209State(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
        
    };

    public SummaryStateEvent(int priority, LSE209State state) {
        super(priority);
        this.state = state;
    }

    @Override
    public LSE209State getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "SummaryStateEvent{" + "state=" + state + '}';
    }
}
