package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class ImageReadinessDetailedStateEvent extends CameraStateChangeEvent {

    public enum ImageReadinessState implements SALEnum<ImageReadinessState> {

        NOT_READY(camera.imageReadinessDetailedState_NOT_READY.value), 
        GETTING_READY(camera.imageReadinessDetailedState_GETTING_READY.value), 
        READY(camera.imageReadinessDetailedState_READY.value);

        private final int salValue;
    
        private ImageReadinessState(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
    };

    private final ImageReadinessState state;
   
    public ImageReadinessDetailedStateEvent(int priority, ImageReadinessState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public ImageReadinessState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "ImageReadinessDetailedState{" + "state=" + state + '}';
    }
    }
