/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEnum;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALTelemetry;

public class SALImplementation<C extends SALCommand, E extends SALEvent, T extends SALTelemetry>
implements SAL<C, E, T> {
    private Object manager;
    private Method salProcessor;
    private Method salEvent;
    private Object cmdInProgress;
    private Object cmdComplete;
    private Object cmdFailed;
    private Method shutdownMethod;
    private int salOK;
    private Method salTelemetrySub;
    private Method salTelemetryPub;
    private final List<SALCommandItem> commands = new ArrayList<SALCommandItem>();
    private final List<SALEventObject> events = new ArrayList<SALEventObject>();
    private final List<SALTelemetryObject> telemetry = new ArrayList<SALTelemetryObject>();

    protected SALImplementation(Class c, String resource) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(c.getResourceAsStream(resource)));){
            this.init(reader);
        }
        catch (IOException | NullPointerException x) {
            throw new RuntimeException("Error reading resource: " + resource, x);
        }
    }

    public SALImplementation(BufferedReader salFile) throws IOException {
        this.init(salFile);
    }

    private void init(BufferedReader salFile) throws IOException, SecurityException, IllegalArgumentException {
        boolean firstLine = true;
        int n = 1;
        while (true) {
            String line = salFile.readLine();
            try {
                if (line == null) break;
                if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                    if (firstLine) {
                        this.createSALManager(line);
                        firstLine = false;
                    } else {
                        String[] split = line.split("\\s+");
                        if (split.length < 3 || (split.length - 3) % 2 != 0) {
                            throw new IOException("Bad line: " + line);
                        }
                        this.createSALObject(split);
                    }
                }
            }
            catch (IOException x) {
                throw new IOException(String.format("Error reading line %d: %s", n, line), x);
            }
            ++n;
        }
    }

    private void createSALManager(String line) throws IllegalArgumentException, SecurityException, IOException {
        try {
            Class<?> managerClass = Class.forName(line);
            this.manager = managerClass.newInstance();
            this.shutdownMethod = managerClass.getMethod("salShutdown", new Class[0]);
            this.cmdInProgress = managerClass.getField("SAL__CMD_INPROGRESS").get(this.manager);
            this.cmdComplete = managerClass.getField("SAL__CMD_COMPLETE").get(this.manager);
            this.cmdFailed = managerClass.getField("SAL__CMD_FAILED").get(this.manager);
            this.salOK = managerClass.getField("SAL__OK").getInt(this.manager);
            this.salProcessor = managerClass.getMethod("salProcessor", String.class);
            this.salEvent = managerClass.getMethod("salEvent", String.class);
            this.salTelemetrySub = managerClass.getMethod("salTelemetrySub", String.class);
            this.salTelemetryPub = managerClass.getMethod("salTelemetryPub", String.class);
        }
        catch (ReflectiveOperationException x) {
            throw new IOException("Error initializing manager class: " + line, x);
        }
    }

    private void createSALObject(String[] line) throws IOException {
        try {
            SALType type = SALType.valueOf(line[0].toUpperCase());
            switch (type) {
                case COMMAND: {
                    this.commands.add(new SALCommandItem(line));
                    break;
                }
                case EVENT: 
                case STATE: {
                    this.events.add(new SALEventObject(line));
                    break;
                }
                case TELEMETRY: {
                    this.telemetry.add(new SALTelemetryObject(line));
                    break;
                }
                default: {
                    throw new IOException("Unsupported type " + (Object)((Object)type));
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new IOException("Error parsing SALFile", ex);
        }
    }

    @Override
    public SALReceivedCommand<C> getNextCommand(Duration timeout) throws SALException {
        return (SALReceivedCommand)this.poll(this.commands, timeout);
    }

    @Override
    public SALCommandResponse issueCommand(C command) throws SALException {
        return (SALCommandResponse)this.send(this.commands, command);
    }

    @Override
    public void logEvent(E event) throws SALException {
        this.send(this.events, event);
    }

    @Override
    public E getNextEvent(Duration timeout) throws SALException {
        return (E)((SALEvent)this.poll(this.events, timeout));
    }

    @Override
    public void sendTelemetry(T telem) throws SALException {
        this.send(this.telemetry, telem);
    }

    @Override
    public T getTelemetry(Duration timeout) throws SALException {
        return (T)((SALTelemetry)this.poll(this.telemetry, timeout));
    }

    private <T extends SALObject, R> R poll(List<T> objects, Duration timeout) throws SALException {
        Instant stop = Instant.now().plus(timeout);
        while (!Instant.now().isAfter(stop)) {
            for (SALObject item : objects) {
                Object result = item.pollForObject();
                if (result == null) continue;
                return (R)result;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new SALException("Unexpected interupt while polling for object", ex);
            }
        }
        return null;
    }

    private <T extends SALObject, SS, R> R send(List<T> objects, SS message) throws SALException {
        for (SALObject salItem : objects) {
            if (!salItem.getSimpleSALClass().isAssignableFrom(message.getClass())) continue;
            return (R)salItem.send(message);
        }
        throw new SALException("Object cannot be sent: " + message);
    }

    @Override
    public void close() throws SALException {
        try {
            this.shutdownMethod.invoke(this.manager, new Object[0]);
        }
        catch (ReflectiveOperationException x) {
            throw new SALException("Error shuting down manager", x);
        }
    }

    private class GenericCommandResponse
    extends SALCommandResponse {
        private final int cmdId;
        private final SALCommandItem commandItem;

        public GenericCommandResponse(int cmdId, SALCommandItem commandItem) {
            this.cmdId = cmdId;
            this.commandItem = commandItem;
        }

        @Override
        public void waitForResponse(Duration timeout) throws SALException {
            this.commandItem.waitForCompletion(this.cmdId, (int)timeout.getSeconds());
        }
    }

    private class GenericReceivedCommand
    extends SALReceivedCommand {
        private final SALCommandItem commandItem;

        public GenericReceivedCommand(int cmdId, SALCommand command, SALCommandItem commandItem) {
            super(cmdId, command);
            this.commandItem = commandItem;
        }

        @Override
        public void acknowledgeCommand(Duration timeToComplete) throws SALException {
            this.acknowledgeCommand(SALImplementation.this.cmdInProgress, (int)timeToComplete.getSeconds(), "Ack : OK");
        }

        @Override
        public void reportComplete() throws SALException {
            this.acknowledgeCommand(SALImplementation.this.cmdComplete, 0, "Done : OK");
        }

        @Override
        public void reportError(Exception ex) throws SALException {
            this.acknowledgeCommand(SALImplementation.this.cmdFailed, 0, "Error : " + ex.getMessage());
        }

        @Override
        public void rejectCommand(String reason) throws SALException {
            this.acknowledgeCommand(SALImplementation.this.cmdFailed, 0, "Ack : NO " + reason);
        }

        private void acknowledgeCommand(Object response, int timeout, String message) throws SALException {
            this.commandItem.acknowledge(this.getCmdId(), response, timeout, message);
        }
    }

    private abstract class SALObject<SS, S> {
        private final SALType type;
        private final Class<SS> simpleSALClass;
        private final Class<S> salClass;
        private final List<SALObjectField> fields;
        private final Constructor simpleSALConstructor;
        private final S salInstance;

        SALObject(String[] line) throws ReflectiveOperationException, IOException {
            this.type = SALType.valueOf(line[0].toUpperCase());
            this.simpleSALClass = Class.forName(line[1]);
            this.salClass = Class.forName(line[2]);
            ArrayList constructorArgTypes = new ArrayList();
            if (line.length == 3) {
                this.fields = Collections.EMPTY_LIST;
            } else {
                this.fields = new ArrayList<SALObjectField>();
                for (int i = 3; i < line.length; i += 2) {
                    Method getter;
                    Class salType = this.parseFieldType(line[i]);
                    Field field = this.salClass.getField(line[i + 1]);
                    if (!(field.getType() == salType || salType.isArray() && field.getType() == salType.getComponentType())) {
                        throw new IOException(String.format("Field %s does not have expected type %s", line[i + 1], line[i]));
                    }
                    if (this.type == SALType.STATE && i == 5) {
                        getter = this.simpleSALClass.getMethod("getSubstate", new Class[0]);
                        if (!getter.getReturnType().isEnum()) {
                            throw new IOException(String.format("Getter for %s does not have expected return type Enum", line[i + 1]));
                        }
                        constructorArgTypes.add(getter.getReturnType());
                    } else {
                        getter = this.simpleSALClass.getMethod(this.getGetterName(line[i + 1], salType), new Class[0]);
                        if (!(getter.getReturnType().isEnum() && salType.isPrimitive() || getter.getReturnType().isArray() && getter.getReturnType().getComponentType().isEnum() && salType.isArray() && salType.getComponentType().isPrimitive() || getter.getReturnType() == salType)) {
                            throw new IOException(String.format("Getter for %s does not have expected return type %s", line[i + 1], line[i]));
                        }
                        constructorArgTypes.add(getter.getReturnType());
                    }
                    this.fields.add(new SALObjectField(line[i + 1], field, getter));
                }
            }
            this.simpleSALConstructor = this.simpleSALClass.getConstructor(constructorArgTypes.toArray(new Class[0]));
            this.salInstance = this.salClass.newInstance();
        }

        private String getGetterName(String field, Class argType) {
            return (argType == Boolean.TYPE ? "is" : "get") + field.substring(0, 1).toUpperCase() + field.substring(1);
        }

        private Class parseFieldType(String typeString) throws ClassNotFoundException {
            boolean isArray = typeString.endsWith("[]");
            if (isArray) {
                typeString = typeString.substring(0, typeString.length() - 2);
            }
            switch (typeString) {
                case "boolean": {
                    return isArray ? boolean[].class : Boolean.TYPE;
                }
                case "int": {
                    return isArray ? int[].class : Integer.TYPE;
                }
                case "short": {
                    return isArray ? short[].class : Short.TYPE;
                }
                case "long": {
                    return isArray ? long[].class : Long.TYPE;
                }
                case "float": {
                    return isArray ? float[].class : Float.TYPE;
                }
                case "double": {
                    return isArray ? double[].class : Double.TYPE;
                }
                case "byte": {
                    return isArray ? byte[].class : Byte.TYPE;
                }
                case "String": {
                    return String.class;
                }
            }
            return Class.forName(typeString);
        }

        SALType getType() {
            return this.type;
        }

        Class<SS> getSimpleSALClass() {
            return this.simpleSALClass;
        }

        Class<S> getSalClass() {
            return this.salClass;
        }

        List<SALObjectField> getFields() {
            return this.fields;
        }

        Constructor<SS> getSimpleSALConstructor() {
            return this.simpleSALConstructor;
        }

        S getSALInstance() {
            return this.salInstance;
        }

        S convertToSAL(SS source) throws ReflectiveOperationException {
            S result = this.getSalClass().newInstance();
            for (SALObjectField arg : this.getFields()) {
                arg.copy(source, result);
            }
            return result;
        }

        SS convertFromSAL(S source) throws ReflectiveOperationException {
            List<SALObjectField> arguments = this.getFields();
            Object[] args = new Object[arguments.size()];
            int i = 0;
            for (SALObjectField arg : arguments) {
                args[i++] = arg.get(source);
            }
            return this.getSimpleSALConstructor().newInstance(args);
        }

        abstract Object pollForObject() throws SALException;

        abstract Object send(SS var1) throws SALException;
    }

    private static class SALObjectField<SS, S, T> {
        private final String name;
        private final Field salField;
        private final Method getter;
        private final Class getterType;
        private final boolean getterIsArray;
        private final boolean salFieldIsArray;
        private final Class salFieldType;

        private SALObjectField(String name, Field field, Method getter) {
            this.name = name;
            this.salField = field;
            this.getter = getter;
            this.getterIsArray = getter.getReturnType().isArray();
            this.getterType = this.getterIsArray ? getter.getReturnType().getComponentType() : getter.getReturnType();
            this.salFieldIsArray = this.salField.getType().isArray();
            this.salFieldType = this.salFieldIsArray ? this.salField.getType().getComponentType() : this.salField.getType();
        }

        private void copy(SS source, S destination) throws ReflectiveOperationException {
            Object value;
            if (this.getterType.isEnum() && this.salFieldType.isPrimitive()) {
                if (this.getterIsArray) {
                    SALEnum[] array = (SALEnum[])this.getter.invoke(source, new Object[0]);
                    int arraySize = Array.getLength(array);
                    value = new short[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        Array.set(value, i, (short)array[i].getSALValue());
                    }
                } else {
                    value = (short)((SALEnum)this.getter.invoke(source, new Object[0])).getSALValue();
                }
            } else {
                value = this.getter.invoke(source, new Object[0]);
            }
            if (value.getClass().isArray() && Array.getLength(value) == 1 && !this.salFieldIsArray) {
                value = Array.get(value, 0);
            }
            this.salField.set(destination, value);
        }

        private Object get(S salInstance) throws ReflectiveOperationException {
            Object result;
            Object array;
            if (this.getterType.isEnum() && this.salFieldType.isPrimitive()) {
                if (this.salFieldIsArray) {
                    array = this.salField.get(salInstance);
                    int arraySize = Array.getLength(array);
                    result = Array.newInstance(this.getterType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        Array.set(result, i, this.getEnum(Array.getInt(array, i)));
                    }
                } else {
                    result = this.getEnum(this.salField.getInt(salInstance));
                }
            } else {
                result = this.salField.get(salInstance);
            }
            if (this.getterIsArray && !this.salFieldIsArray) {
                array = Array.newInstance(this.getterType, 1);
                Array.set(array, 0, result);
                return array;
            }
            return result;
        }

        private Object getEnum(int value) throws IllegalArgumentException, ReflectiveOperationException, IllegalAccessException {
            for (Enum e : (Enum[])this.getterType.getEnumConstants()) {
                if (((SALEnum)((Object)e)).getSALValue() != value) continue;
                return e;
            }
            throw new ReflectiveOperationException(String.format("Cannot find enumeration of class %s for value %d", this.getter.getReturnType(), value));
        }
    }

    private class SALCommandItem<SS extends SALCommand, S>
    extends SALObject<SS, S> {
        private Method acceptMethod;
        private Method acknowledgeMethod;
        private Method issueMethod;
        private Method waitForCompletionMethod;

        SALCommandItem(String[] line) throws ReflectiveOperationException, IOException {
            super(line);
            if (!SALCommand.class.isAssignableFrom(this.getSimpleSALClass())) {
                throw new IOException("Class " + this.getSimpleSALClass() + " not valid for type " + (Object)((Object)this.getType()));
            }
            SALImplementation.this.salProcessor.invoke(SALImplementation.this.manager, line[2].replace(".", "_"));
            this.acceptMethod = SALImplementation.this.manager.getClass().getMethod("acceptCommand_" + line[2].replaceFirst(".*command_", ""), this.getSalClass());
            this.acknowledgeMethod = SALImplementation.this.manager.getClass().getMethod("ackCommand_" + line[2].replaceFirst(".*command_", ""), Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
            this.issueMethod = SALImplementation.this.manager.getClass().getMethod("issueCommand_" + line[2].replaceFirst(".*command_", ""), this.getSalClass());
            this.waitForCompletionMethod = SALImplementation.this.manager.getClass().getMethod("waitForCompletion_" + line[2].replaceFirst(".*command_", ""), Integer.TYPE, Integer.TYPE);
        }

        private void acknowledge(int cmdId, S response, int timeout, String message) throws SALException {
            try {
                this.acknowledgeMethod.invoke(SALImplementation.this.manager, cmdId, response, timeout, message);
            }
            catch (ReflectiveOperationException x) {
                throw new SALException("Error acknowledging command", x);
            }
        }

        private void waitForCompletion(int cmdId, int timeout) throws SALException {
            try {
                this.waitForCompletionMethod.invoke(SALImplementation.this.manager, cmdId, timeout);
            }
            catch (ReflectiveOperationException x) {
                throw new SALException("Error waiting for completion", x);
            }
        }

        @Override
        SALReceivedCommand pollForObject() throws SALException {
            try {
                Object salInstance = this.getSALInstance();
                int cmdId = (Integer)this.acceptMethod.invoke(SALImplementation.this.manager, salInstance);
                if (cmdId != 0) {
                    return new GenericReceivedCommand(cmdId, (SALCommand)this.convertFromSAL(salInstance), this);
                }
                return null;
            }
            catch (ReflectiveOperationException ex) {
                throw new SALException("Error invoking accept method", ex);
            }
        }

        @Override
        SALCommandResponse send(SS message) throws SALException {
            try {
                int cmdId = (Integer)this.issueMethod.invoke(SALImplementation.this.manager, this.convertToSAL(message));
                return new GenericCommandResponse(cmdId, this);
            }
            catch (ReflectiveOperationException x) {
                throw new SALException("Error converting command", x);
            }
        }
    }

    private class SALEventObject<SS extends SALEvent, S>
    extends SALObject<SS, S> {
        private Method logEventMethod;
        private Method getEventMethod;

        SALEventObject(String[] line) throws ReflectiveOperationException, IOException {
            super(line);
            if (!SALEvent.class.isAssignableFrom(this.getSimpleSALClass())) {
                throw new IOException("Class " + this.getSimpleSALClass() + " not valid for type " + (Object)((Object)this.getType()));
            }
            SALImplementation.this.salEvent.invoke(SALImplementation.this.manager, line[2].replace(".", "_"));
            this.logEventMethod = SALImplementation.this.manager.getClass().getMethod("logEvent_" + line[2].replaceFirst(".*logevent_", ""), this.getSalClass(), Integer.TYPE);
            this.getEventMethod = SALImplementation.this.manager.getClass().getMethod("getEvent_" + line[2].replaceFirst(".*logevent_", ""), this.getSalClass());
        }

        @Override
        SS pollForObject() throws SALException {
            try {
                Object salInstance = this.getSALInstance();
                int rc = (Integer)this.getEventMethod.invoke(SALImplementation.this.manager, salInstance);
                if (rc == SALImplementation.this.salOK) {
                    return (SS)((SALEvent)this.convertFromSAL(salInstance));
                }
                return null;
            }
            catch (ReflectiveOperationException ex) {
                throw new SALException("Error invoking logEvent method", ex);
            }
        }

        @Override
        Object send(SS message) throws SALException {
            try {
                this.logEventMethod.invoke(SALImplementation.this.manager, this.convertToSAL(message), ((SALEvent)message).getPriority());
                return null;
            }
            catch (ReflectiveOperationException ex) {
                throw new SALException("Error invoking logEvent method", ex);
            }
        }
    }

    private class SALTelemetryObject<SS extends SALTelemetry, S>
    extends SALObject<SS, S> {
        private Method putSampleMethod;
        private Method getSampleMethod;

        SALTelemetryObject(String[] line) throws ReflectiveOperationException, IOException {
            super(line);
            if (!SALTelemetry.class.isAssignableFrom(this.getSimpleSALClass())) {
                throw new IOException("Class " + this.getSimpleSALClass() + " not valid for type " + (Object)((Object)this.getType()));
            }
            SALImplementation.this.salTelemetrySub.invoke(SALImplementation.this.manager, line[2].replace(".", "_"));
            SALImplementation.this.salTelemetryPub.invoke(SALImplementation.this.manager, line[2].replace(".", "_"));
            this.putSampleMethod = SALImplementation.this.manager.getClass().getMethod("putSample", this.getSalClass());
            this.getSampleMethod = SALImplementation.this.manager.getClass().getMethod("getSample", this.getSalClass());
        }

        @Override
        SS pollForObject() throws SALException {
            try {
                Object salInstance = this.getSALInstance();
                int rc = (Integer)this.getSampleMethod.invoke(SALImplementation.this.manager, salInstance);
                if (rc == SALImplementation.this.salOK) {
                    return (SS)((SALTelemetry)this.convertFromSAL(salInstance));
                }
                return null;
            }
            catch (ReflectiveOperationException ex) {
                throw new SALException("Error invoking logEvent method", ex);
            }
        }

        @Override
        Object send(SS message) throws SALException {
            try {
                this.putSampleMethod.invoke(SALImplementation.this.manager, this.convertToSAL(message));
            }
            catch (ReflectiveOperationException ex) {
                throw new SALException("Error invoking putSample method", ex);
            }
            return null;
        }
    }

    private static enum SALType {
        COMMAND,
        EVENT,
        STATE,
        TELEMETRY;

    }
}

