package org.lsst.sal.camera.states;

import camera.SummaryState_DisabledState;
import camera.SummaryState_EnabledState;
import camera.SummaryState_FaultState;
import camera.SummaryState_OfflineState;
import camera.SummaryState_StandbyState;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 * The SummaryStateEvent (for LSE209 state changes)
 * @author tonyj
 */
public class SummaryStateEvent extends CameraStateChangeEvent {

    private final LSE209State state;

    public enum LSE209State implements SALEnum<LSE209State> {
        OFFLINE(SummaryState_OfflineState.value), 
        STANDBY(SummaryState_StandbyState.value), 
        DISABLED(SummaryState_DisabledState.value), 
        ENABLED(SummaryState_EnabledState.value), 
        FAULT(SummaryState_FaultState.value);

        private final int salValue;
        
        private LSE209State(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
        
    };

    public SummaryStateEvent(int priority, LSE209State state) {
        super(priority);
        this.state = state;
    }

    @Override
    public LSE209State getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "SummaryStateEvent{" + "state=" + state + '}';
    }
}
