package org.lsst.sal.camera.states;

import camera.shutterDetailedState_CLOSED;
import camera.shutterDetailedState_CLOSING;
import camera.shutterDetailedState_OPEN;
import camera.shutterDetailedState_OPENING;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class ShutterDetailedStateEvent extends CameraStateChangeEvent {

    public enum ShutterState implements SALEnum<ShutterState> {

        CLOSED(shutterDetailedState_CLOSED.value), 
        OPENING(shutterDetailedState_OPENING.value), 
        OPEN(shutterDetailedState_OPEN.value), 
        CLOSING(shutterDetailedState_CLOSING.value);
        
        private final int salValue;
        
        private ShutterState(int salValue) {
            this.salValue = salValue;
        }

        @Override
        public int getSALValue() {
            return salValue;
        }
    };

    private final ShutterState state;

    public ShutterDetailedStateEvent(int priority, ShutterState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public ShutterState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "ShutterDetailedStateEvent{" + "state=" + state + '}';
    }
}
