package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 *
 * @author tonyj
 */
public class CCSCommandStateEvent extends CameraStateChangeEvent {

    public enum IdleBusyState implements SALEnum<IdleBusyState> {

        IDLE, BUSY
    };

    private final IdleBusyState state;
    
    public CCSCommandStateEvent(int priority, IdleBusyState state) {
        super(priority);
        this.state = state;
    }

    @Override
    public IdleBusyState getSubstate() {
        return state;
    }

    @Override
    public String toString() {
        return "CCSCommandStateEvent{" + "state=" + state + '}';
    }

}
