package org.lsst.sal.camera.event;

import java.text.SimpleDateFormat;
import org.lsst.sal.camera.CameraEvent;

/**
 * Start Integration event.
 *
 * @author tonyj
 */
public class StartRaftIntegrationEvent extends CameraEvent {

    private final String imageName;
    private final String imageSequenceName;
    private final int imagesInSequence;
    private final int imageIndex;
    private final double timeStamp;
    private final static SimpleDateFormat DTF = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS");
    private final double exposureTime;

    public StartRaftIntegrationEvent(int priority, String imageSequenceName, int imagesInSequence, String imageName, int imageIndex, double timeStamp, double exposureTime) {
        super(priority);
        this.imageSequenceName = imageSequenceName;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.imageIndex = imageIndex;
        this.timeStamp = timeStamp;
        this.exposureTime = exposureTime;
    }

    public String getImageName() {
        return imageName;
    }

    public String getImageSequenceName() {
        return imageSequenceName;
    }

    public int getImagesInSequence() {
        return imagesInSequence;
    }

    public int getImageIndex() {
        return imageIndex;
    }

    public double getTimeStamp() {
        return timeStamp;
    }

    public double getExposureTime() {
        return exposureTime;
    }

    @Override
    public String toString() {
        return "StartRaftIntegrationEvent{" + "imageName=" + imageName + ", imageSequenceName=" + imageSequenceName + ", imagesInSequence=" + imagesInSequence + ", imageIndex=" + imageIndex + ", timeStamp=" + timeStamp + ", exposureTime=" + exposureTime + '}';
    }

    static String toUTC(double timeStamp) {
        return DTF.format((long) (timeStamp/1000.0));
    }

}
