package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

/**
 * Settings applied. This is largely a placeholder event pending more] thought..
 *
 * @author tonyj
 */
public class SettingsAppliedEvent extends CameraEvent {

    private final String settings;
    private final double timestamp;

    public SettingsAppliedEvent(int priority, String settings, double timestamp) {
        super(priority);
        this.settings = settings;
        this.timestamp = timestamp;
    }

    public String getSettings() {
        return settings;
    }

    public double getTimestamp() {
        return timestamp;
    }

    @Override
    public String toString() {
        return "SettingsApplied{" + "settings=" + settings + ", timestamp=" + timestamp + '}';
    }
}
