package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

/**
 * The SettingVersionsEvent
 * @author tonyj
 */
public class SettingVersionsEvent extends CameraEvent {

    private final String recommendedSettingVersion;

    public SettingVersionsEvent(int priority, String recommendedSettingVersion) {
        super(priority);
        this.recommendedSettingVersion = recommendedSettingVersion;
    }

    public String getRecommendedSettingVersion() {
        return recommendedSettingVersion;
    }

    @Override
    public String toString() {
        return "SettingVersionsEvent{" + "recommendedSettingVersion=" + recommendedSettingVersion + '}';
    }

}