package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

/**
 *
 * @author Farrukh Azfar
 */
public class EndOfImageTelemetryEvent extends CameraEvent {
    
    private final String imageSequenceName;
    private final int imagesInSequence;
    private final String imageName;
    private final int imageIndex;
    private final double timeStamp;
    private final double exposureTime;    

    public EndOfImageTelemetryEvent(int priority, String imageSequenceName, int imagesInSequence, String imageName, int imageIndex, double timeStamp, double exposureTime) {
        super(priority);
        this.imageSequenceName = imageSequenceName;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.imageIndex = imageIndex;
        this.timeStamp = timeStamp;
        this.exposureTime = exposureTime;
    }

    public String getImageName() {
        return imageName;
    }

    public String getImageSequenceName() {
        return imageSequenceName;
    }

    public int getImagesInSequence() {
        return imagesInSequence;
    }

    public int getImageIndex() {
        return imageIndex;
    }

    public double getTimeStamp() {
        return timeStamp;
    }

    public double getExposureTime() {
        return exposureTime;
    }

    @Override
    public String toString() {
        return "EndOfImageTelemetryEvent{" + "imageSequenceName=" + imageSequenceName + ", imagesInSequence=" + imagesInSequence + ", imageName=" + imageName + ", imageIndex=" + imageIndex + ", timeStamp=" + timeStamp + ", exposureTime=" + exposureTime + '}';
    }
    
}
