package org.lsst.sal.atheader.event;

import org.lsst.sal.SALEvent;

public class LogMessageEvent extends SALEvent {
  private final String name;

  private final int level;

  private final String message;

  private final String traceback;

  private final String filePath;

  private final String functionName;

  private final int lineNumber;

  private final int process;

  private final double timestamp;

  public LogMessageEvent(String name, int level, String message, String traceback, String filePath,
      String functionName, int lineNumber, int process, double timestamp) {
    this.name = name;
    this.level = level;
    this.message = message;
    this.traceback = traceback;
    this.filePath = filePath;
    this.functionName = functionName;
    this.lineNumber = lineNumber;
    this.process = process;
    this.timestamp = timestamp;
  }

  public String getName() {
    return name;
  }

  public int getLevel() {
    return level;
  }

  public String getMessage() {
    return message;
  }

  public String getTraceback() {
    return traceback;
  }

  public String getFilePath() {
    return filePath;
  }

  public String getFunctionName() {
    return functionName;
  }

  public int getLineNumber() {
    return lineNumber;
  }

  public int getProcess() {
    return process;
  }

  public double getTimestamp() {
    return timestamp;
  }

  @Override
  public String toString() {
    return "LogMessageEvent{" + "name=" + name +", level=" + level +", message=" + message +
        ", traceback=" + traceback +", filePath=" + filePath +", functionName=" + functionName +
        ", lineNumber=" + lineNumber +", process=" + process +", timestamp=" + timestamp +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private int level;

    private String message;

    private String traceback;

    private String filePath;

    private String functionName;

    private int lineNumber;

    private int process;

    private double timestamp;

    private Builder() {
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder level(int level) {
      this.level = level;
      return this;
    }

    public Builder message(String message) {
      this.message = message;
      return this;
    }

    public Builder traceback(String traceback) {
      this.traceback = traceback;
      return this;
    }

    public Builder filePath(String filePath) {
      this.filePath = filePath;
      return this;
    }

    public Builder functionName(String functionName) {
      this.functionName = functionName;
      return this;
    }

    public Builder lineNumber(int lineNumber) {
      this.lineNumber = lineNumber;
      return this;
    }

    public Builder process(int process) {
      this.process = process;
      return this;
    }

    public Builder timestamp(double timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    public LogMessageEvent build() {
      return new LogMessageEvent(name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp);
    }
  }
}
