package org.lsst.sal.atheader.event;

import org.lsst.sal.SALEvent;

public class SettingVersionsEvent extends SALEvent {
  private final String recommendedSettingsVersion;

  private final String recommendedSettingsLabels;

  private final String settingsUrl;

  public SettingVersionsEvent(int priority, String recommendedSettingsVersion,
      String recommendedSettingsLabels, String settingsUrl) {
    super (priority);
    this.recommendedSettingsVersion = recommendedSettingsVersion;
    this.recommendedSettingsLabels = recommendedSettingsLabels;
    this.settingsUrl = settingsUrl;
  }

  public String getRecommendedSettingsVersion() {
    return recommendedSettingsVersion;
  }

  public String getRecommendedSettingsLabels() {
    return recommendedSettingsLabels;
  }

  public String getSettingsUrl() {
    return settingsUrl;
  }

  @Override
  public String toString() {
    return "SettingVersionsEvent{" + "recommendedSettingsVersion=" + recommendedSettingsVersion +
        ", recommendedSettingsLabels=" + recommendedSettingsLabels +", settingsUrl=" + settingsUrl +
        "}";
  }
}
