package org.lsst.sal.atheader.event;

import org.lsst.sal.SALEvent;

public class AuthListEvent extends SALEvent {
  private final String authorizedUsers;

  private final String nonAuthorizedCSCs;

  public AuthListEvent(int priority, String authorizedUsers, String nonAuthorizedCSCs) {
    super (priority);
    this.authorizedUsers = authorizedUsers;
    this.nonAuthorizedCSCs = nonAuthorizedCSCs;
  }

  public String getAuthorizedUsers() {
    return authorizedUsers;
  }

  public String getNonAuthorizedCSCs() {
    return nonAuthorizedCSCs;
  }

  @Override
  public String toString() {
    return "AuthListEvent{" + "authorizedUsers=" + authorizedUsers +
        ", nonAuthorizedCSCs=" + nonAuthorizedCSCs +"}";
  }
}
