/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)1, (int)-811073032);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)-1506982973);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)-1564011684);
        double[] oGV = TestHelper.generateDoubleArray((int)1, (int)1467941290);
        double[] rDV = TestHelper.generateDoubleArray((int)1, (int)-746221728);
        double[] temp = TestHelper.generateDoubleArray((int)1, (int)589888748);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)1, (int)-1060068817);
        double[] anaV = TestHelper.generateDoubleArray((int)1, (int)-354262390);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)1, (int)-1886193386);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)1, (int)-1967870779);
        double[] clkHI = TestHelper.generateDoubleArray((int)1, (int)-1801855087);
        double[] clkHV = TestHelper.generateDoubleArray((int)1, (int)1278797987);
        double[] clkLV = TestHelper.generateDoubleArray((int)1, (int)-1013002884);
        double[] digI = TestHelper.generateDoubleArray((int)1, (int)-800280453);
        double[] digV = TestHelper.generateDoubleArray((int)1, (int)-546522803);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)1, (int)777132694);
        double[] htrPI = TestHelper.generateDoubleArray((int)1, (int)-101645736);
        double[] htrPV = TestHelper.generateDoubleArray((int)1, (int)928453471);
        double[] htrV = TestHelper.generateDoubleArray((int)1, (int)415119978);
        double[] htrW = TestHelper.generateDoubleArray((int)1, (int)616246464);
        String location = "y";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)564681629);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)1121254043);
        double[] pClk0 = TestHelper.generateDoubleArray((int)1, (int)-816058077);
        double[] pClkL = TestHelper.generateDoubleArray((int)1, (int)-541065889);
        double[] pClkU = TestHelper.generateDoubleArray((int)1, (int)608954111);
        double[] power = TestHelper.generateDoubleArray((int)1, (int)755348069);
        double[] rG0 = TestHelper.generateDoubleArray((int)1, (int)1452908335);
        double[] rGL = TestHelper.generateDoubleArray((int)1, (int)-1637505314);
        double[] rGU = TestHelper.generateDoubleArray((int)1, (int)-1950326017);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)1, (int)1743197950);
        double[] sClk0 = TestHelper.generateDoubleArray((int)1, (int)-771233578);
        double[] sClkL = TestHelper.generateDoubleArray((int)1, (int)1923854614);
        double[] sClkU = TestHelper.generateDoubleArray((int)1, (int)1361262745);
        double[] temp1 = TestHelper.generateDoubleArray((int)1, (int)335313942);
        double[] temp2 = TestHelper.generateDoubleArray((int)1, (int)328477993);
        double[] temp3 = TestHelper.generateDoubleArray((int)1, (int)1911665011);
        double[] temp4 = TestHelper.generateDoubleArray((int)1, (int)1974896839);
        double[] temp5 = TestHelper.generateDoubleArray((int)1, (int)-7741305);
        double[] temp6 = TestHelper.generateDoubleArray((int)1, (int)740506472);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicu_Temp0, clkHI, clkHV, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClkL, pClkU, power, rG0, rGL, rGU, rTDTemp, sClk0, sClkL, sClkU, temp1, temp2, temp3, temp4, temp5, temp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.1978340744972229;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.17217093706130981;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)1, (int)-1378366722);
        long[] driver_received = TestHelper.generateLongArray((int)1, (int)450993372);
        long[] driver_rx0 = TestHelper.generateLongArray((int)1, (int)2067130345);
        long[] driver_rx1 = TestHelper.generateLongArray((int)1, (int)-1569038273);
        long[] driver_rx2 = TestHelper.generateLongArray((int)1, (int)700828897);
        long[] driver_rx3 = TestHelper.generateLongArray((int)1, (int)2037262307);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)1, (int)-1094079358);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)1, (int)-2121750515);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)1, (int)-616050836);
        long[] firmware_link_down = TestHelper.generateLongArray((int)1, (int)1253191756);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)1, (int)-802871414);
        long[] firmware_link_status = TestHelper.generateLongArray((int)1, (int)1682383139);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)1, (int)847810333);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)1, (int)1268508900);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)1, (int)19006446);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)1, (int)-471059455);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)1, (int)-2110920366);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)1, (int)186960465);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)1, (int)-1053081626);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)1, (int)1375748643);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)1, (int)1793187887);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)1, (int)458691357);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)1, (int)-664359555);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)1, (int)572519981);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)1, (int)2131589317);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)1, (int)-1398622955);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)1, (int)2028435280);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)1, (int)9888612);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)1, (int)1692456816);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)1, (int)2067639701);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)1, (int)130033760);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)1, (int)2023112320);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)1, (int)-1031948134);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)1, (int)1460871007);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)1, (int)-893253377);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)1, (int)1871958810);
        long[] rds_discards = TestHelper.generateLongArray((int)1, (int)-644472991);
        long[] rds_no_event = TestHelper.generateLongArray((int)1, (int)-2092563425);
        long[] rds_wakes = TestHelper.generateLongArray((int)1, (int)-1944800355);
        long[] rms_in_reset = TestHelper.generateLongArray((int)1, (int)-1997910944);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)1, (int)-1043693262);
        long[] rms_link_down = TestHelper.generateLongArray((int)1, (int)1245067630);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)1, (int)-258759295);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)1, (int)-1628639025);
        long[] rms_orphans = TestHelper.generateLongArray((int)1, (int)-853434444);
        long[] rms_probes = TestHelper.generateLongArray((int)1, (int)1182931208);
        long[] rms_responses = TestHelper.generateLongArray((int)1, (int)-2015599975);
        long[] rms_rundowns = TestHelper.generateLongArray((int)1, (int)-1031698967);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)1, (int)1907447301);
        long[] rms_unopened = TestHelper.generateLongArray((int)1, (int)1672227611);
        long[] rms_waits = TestHelper.generateLongArray((int)1, (int)1068790890);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.6310590505599976;
        double freeFraction = 0.7730971574783325;
        double freeSpace = 0.6482424736022949;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 600L;
        long firmware_cell_errors = 303L;
        long firmware_link_down = 63L;
        long firmware_link_errors = 213L;
        long firmware_overflow_local0 = 951L;
        long firmware_overflow_local1 = 942L;
        long firmware_overflow_local2 = 592L;
        long firmware_overflow_remote0 = 88L;
        long firmware_overflow_remote1 = 801L;
        long firmware_overflow_remote2 = 87L;
        long firmware_rx_errors = 223L;
        long firmware_tx_errors = 514L;
        long rds_bdi_nulls = 147L;
        long rds_bdi_overflows = 485L;
        long rds_bdi_seq_errors = 653L;
        long rds_discards = 590L;
        long rds_no_event = 992L;
        long rms_in_reset = 466L;
        long rms_inv_tids = 972L;
        long rms_link_down = 201L;
        long rms_orphans = 928L;
        long rms_unopened = 381L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceivePowerTelemetry() throws Exception {
        double analog_I = 0.6647447347640991;
        double analog_V = 0.09924596548080444;
        double aux_I = 0.388649046421051;
        double aux_V = 0.192366361618042;
        double clkhigh_I = 0.3791356682777405;
        double clkhigh_V = 0.6766318678855896;
        double clklow_I = 0.4565402865409851;
        double clklow_V = 0.5763600468635559;
        double dphi_I = 0.8063295483589172;
        double dphi_V = 0.20522820949554443;
        double digital_I = 0.04169929027557373;
        double digital_V = 0.5060730576515198;
        double fan_I = 0.4233966f;
        double fan_V = 0.02714228630065918;
        double hvbias_I = 0.20204466581344604;
        double hvbias_V = 0.4414917230606079;
        double od_I = 0.8437589406967163;
        double od_V = 0.8764467239379883;
        double otm_I = 0.4024495482444763;
        double otm_V = 0.42289382219314575;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PowerTelemetry(analog_I, analog_V, aux_I, aux_V, clkhigh_I, clkhigh_V, clklow_I, clklow_V, dphi_I, dphi_V, digital_I, digital_V, fan_I, fan_V, hvbias_I, hvbias_V, od_I, od_V, otm_I, otm_V));
        Assert.assertTrue((boolean)(item instanceof PowerTelemetry));
        PowerTelemetry item_ = (PowerTelemetry)item;
        Assert.assertEquals((double)analog_I, (double)item_.getAnalog_I(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_V, (double)item_.getAnalog_V(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_I, (double)item_.getAux_I(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_V, (double)item_.getAux_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_I, (double)item_.getClkhigh_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_V, (double)item_.getClkhigh_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_I, (double)item_.getClklow_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_V, (double)item_.getClklow_V(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_I, (double)item_.getDphi_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_V, (double)item_.getDphi_V(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_I, (double)item_.getDigital_I(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_V, (double)item_.getDigital_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_I, (double)item_.getFan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_V, (double)item_.getFan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_I, (double)item_.getHvbias_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_V, (double)item_.getHvbias_V(), (double)1.0E-6f);
        Assert.assertEquals((double)od_I, (double)item_.getOd_I(), (double)1.0E-6f);
        Assert.assertEquals((double)od_V, (double)item_.getOd_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_I, (double)item_.getOtm_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_V, (double)item_.getOtm_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        double tempCCD = 0.9662340879440308;
        double tempCCDSetPoint = 0.11944049596786499;
        double tempColdPlate = 0.7138491868972778;
        double tempCryoHead = 0.15329605340957642;
        double vacuum = 0.3902401328086853;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempCCDSetPoint, tempColdPlate, tempCryoHead, vacuum));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((double)tempCCD, (double)item_.getTempCCD(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCCDSetPoint, (double)item_.getTempCCDSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempColdPlate, (double)item_.getTempColdPlate(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCryoHead, (double)item_.getTempCryoHead(), (double)1.0E-6f);
        Assert.assertEquals((double)vacuum, (double)item_.getVacuum(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.1239391f;
        double bonn_V5 = 0.8015385270118713;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }
}

