package org.lsst.sal.atcamera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_Reb_RaftsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double[] bias0_csGateP;

  private final double[] bias0_gdP;

  private final double[] bias0_odP;

  private final double[] bias0_ogP;

  private final double[] bias0_rdP;

  private final double[] dac_pclkHighP;

  private final double[] dac_pclkLowP;

  private final double[] dac_rgHighP;

  private final double[] dac_rgLowP;

  private final double[] dac_sclkHighP;

  private final double[] dac_sclkLowP;

  private final boolean[] disableRTDHardwareCheck;

  private final String location;

  private final long[] serialNum;

  public Focal_plane_Reb_RaftsConfigurationEvent(String version, double[] bias0_csGateP,
      double[] bias0_gdP, double[] bias0_odP, double[] bias0_ogP, double[] bias0_rdP,
      double[] dac_pclkHighP, double[] dac_pclkLowP, double[] dac_rgHighP, double[] dac_rgLowP,
      double[] dac_sclkHighP, double[] dac_sclkLowP, boolean[] disableRTDHardwareCheck,
      String location, long[] serialNum) {
    this.version = version;
    this.bias0_csGateP = bias0_csGateP;
    this.bias0_gdP = bias0_gdP;
    this.bias0_odP = bias0_odP;
    this.bias0_ogP = bias0_ogP;
    this.bias0_rdP = bias0_rdP;
    this.dac_pclkHighP = dac_pclkHighP;
    this.dac_pclkLowP = dac_pclkLowP;
    this.dac_rgHighP = dac_rgHighP;
    this.dac_rgLowP = dac_rgLowP;
    this.dac_sclkHighP = dac_sclkHighP;
    this.dac_sclkLowP = dac_sclkLowP;
    this.disableRTDHardwareCheck = disableRTDHardwareCheck;
    this.location = location;
    this.serialNum = serialNum;
  }

  public String getVersion() {
    return version;
  }

  public double[] getBias0_csGateP() {
    return bias0_csGateP;
  }

  public double[] getBias0_gdP() {
    return bias0_gdP;
  }

  public double[] getBias0_odP() {
    return bias0_odP;
  }

  public double[] getBias0_ogP() {
    return bias0_ogP;
  }

  public double[] getBias0_rdP() {
    return bias0_rdP;
  }

  public double[] getDac_pclkHighP() {
    return dac_pclkHighP;
  }

  public double[] getDac_pclkLowP() {
    return dac_pclkLowP;
  }

  public double[] getDac_rgHighP() {
    return dac_rgHighP;
  }

  public double[] getDac_rgLowP() {
    return dac_rgLowP;
  }

  public double[] getDac_sclkHighP() {
    return dac_sclkHighP;
  }

  public double[] getDac_sclkLowP() {
    return dac_sclkLowP;
  }

  public boolean[] getDisableRTDHardwareCheck() {
    return disableRTDHardwareCheck;
  }

  public String getLocation() {
    return location;
  }

  public long[] getSerialNum() {
    return serialNum;
  }

  @Override
  public String toString() {
    return "Focal_plane_Reb_RaftsConfigurationEvent{" + "version=" + version +
        ", bias0_csGateP=" + Arrays.toString(bias0_csGateP) +
        ", bias0_gdP=" + Arrays.toString(bias0_gdP) +", bias0_odP=" + Arrays.toString(bias0_odP) +
        ", bias0_ogP=" + Arrays.toString(bias0_ogP) +", bias0_rdP=" + Arrays.toString(bias0_rdP) +
        ", dac_pclkHighP=" + Arrays.toString(dac_pclkHighP) +
        ", dac_pclkLowP=" + Arrays.toString(dac_pclkLowP) +
        ", dac_rgHighP=" + Arrays.toString(dac_rgHighP) +
        ", dac_rgLowP=" + Arrays.toString(dac_rgLowP) +
        ", dac_sclkHighP=" + Arrays.toString(dac_sclkHighP) +
        ", dac_sclkLowP=" + Arrays.toString(dac_sclkLowP) +
        ", disableRTDHardwareCheck=" + Arrays.toString(disableRTDHardwareCheck) +
        ", location=" + location +", serialNum=" + Arrays.toString(serialNum) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double[] bias0_csGateP;

    private double[] bias0_gdP;

    private double[] bias0_odP;

    private double[] bias0_ogP;

    private double[] bias0_rdP;

    private double[] dac_pclkHighP;

    private double[] dac_pclkLowP;

    private double[] dac_rgHighP;

    private double[] dac_rgLowP;

    private double[] dac_sclkHighP;

    private double[] dac_sclkLowP;

    private boolean[] disableRTDHardwareCheck;

    private String location;

    private long[] serialNum;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder bias0_csGateP(double[] bias0_csGateP) {
      this.bias0_csGateP = bias0_csGateP;
      return this;
    }

    public Builder bias0_gdP(double[] bias0_gdP) {
      this.bias0_gdP = bias0_gdP;
      return this;
    }

    public Builder bias0_odP(double[] bias0_odP) {
      this.bias0_odP = bias0_odP;
      return this;
    }

    public Builder bias0_ogP(double[] bias0_ogP) {
      this.bias0_ogP = bias0_ogP;
      return this;
    }

    public Builder bias0_rdP(double[] bias0_rdP) {
      this.bias0_rdP = bias0_rdP;
      return this;
    }

    public Builder dac_pclkHighP(double[] dac_pclkHighP) {
      this.dac_pclkHighP = dac_pclkHighP;
      return this;
    }

    public Builder dac_pclkLowP(double[] dac_pclkLowP) {
      this.dac_pclkLowP = dac_pclkLowP;
      return this;
    }

    public Builder dac_rgHighP(double[] dac_rgHighP) {
      this.dac_rgHighP = dac_rgHighP;
      return this;
    }

    public Builder dac_rgLowP(double[] dac_rgLowP) {
      this.dac_rgLowP = dac_rgLowP;
      return this;
    }

    public Builder dac_sclkHighP(double[] dac_sclkHighP) {
      this.dac_sclkHighP = dac_sclkHighP;
      return this;
    }

    public Builder dac_sclkLowP(double[] dac_sclkLowP) {
      this.dac_sclkLowP = dac_sclkLowP;
      return this;
    }

    public Builder disableRTDHardwareCheck(boolean[] disableRTDHardwareCheck) {
      this.disableRTDHardwareCheck = disableRTDHardwareCheck;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder serialNum(long[] serialNum) {
      this.serialNum = serialNum;
      return this;
    }

    public Focal_plane_Reb_RaftsConfigurationEvent build() {
      return new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum);
    }
  }
}
